cls
?"PCOS BASIC Compiler    version 1.0 beta"
?"2007 by Mercury0x000D"
?

'This program is freeware, use as you wish.

on error goto compileError

defint a-z
dim jumps$(0 to 1023), jumps???(0 to 1023)
shared jumps$(), jumps???()

'this is for the default data types set by the def(type) statements...
dim varDefaults(1 to 26)
shared varDefaults()

'var type constants...
shared kByte, kWord, kInteger, kDword, kLong, kQuad, kSingle
shared kDouble, kExt, kFix, kBcd, kPtr, kString, kUserDefined
shared kSUB, kLineLabel

'for subroutines and variables...
dim objList$(1 to 1024)
shared objList$(), objListCounter

'user-defined types...
dim userTypes$(0 to 1023)
shared userTypes$(), userTypeCounter

'this holds the name of the procedure that's currently being compiled
shared currentProcName$

'to hold the address which the next var to be defined will get
shared nextAddress???

'to hold a list of the sizes of the supported data types
dim varSize(1 to 12)
shared varSize()

'this is the current statement...
shared statement$

'these hold the argument portion of the current statement...
shared arg$, argLow$

'Initalize variables and tables...
varSize(1) = 1
varSize(2) = 2
varSize(3) = 2
varSize(4) = 4
varSize(5) = 4
varSize(6) = 8
varSize(7) = 4
varSize(8) = 8
varSize(9) = 10
varSize(10) = 8
varSize(11) = 10
varSize(12) = 4

kByte = 1
kWord = 2
kInteger = 3
kDword = 4
kLong = 5
kQuad = 6
kSingle = 7
kDouble = 8
kExt = 9
kFix = 10
kBcd = 11
kPtr = 12
kString = 13
kUserDefined = 14
kSUB = 15
kLineLabel = 16




InitJumps
cmdString$ = command$

if cmdString$ = "" then
 ?"You must specify a filename. Program exiting."
 system
end if

?"Opening files... ";
LastOfFspec cmdString$, file$
SplitFilename file$, n$, e$
GetParentPath cmdString$, cmdParent$
newFile$ = cmdParent$ + "\temp.asm"
open cmdString$ for input as #1
open newFile$ for output as #2

?"done."
?

?"Searching source for sub and line label references... ";
do while not eof(1)
 line input #1, a$
 if ltrim$(lcase$(left$(a$, 3))) = "sub" then
  GetWord a$, b$, " ", 2, dummy
  c$ = " "
  counter = 3
  do until c$ = ""
   GetWord a$, c$, " ", counter, dummy
   if c$ <> "" then incr numArgs
   incr counter
  loop
  GetObjNumber "sub_" + b$, objNum, numArgs
 end if
 if right$(a$, 1) = ":" then GetObjNumber a$, objNum, 1
loop
close #1
open cmdString$ for input as #1
?"done."


?"Compiling..."
?
currentProcName$ = "*"
'this adds variables that the BASIC language needs for its own use...
GetObjNumber "*cursorH", objNum, 1
GetObjNumber "*cursorV", objNum, 1

do while not eof(1)
 statement$ = " "
 do until statement$ = ""
  writeStr$ = ""
  if inkey$ = chr$(27) then
   color 4
   ?
   ?"Compile terminated by user. Program exiting."
   ?
   color 7
   system
  end if
  gosub GetNextStatement
  if statement$ = "" then iterate
  if left$(statement$, 1) = "#" then
   ?#2, currentLine$
   'call this again to make things line up properly...
   gosub GetNextStatement
   iterate
  end if
  if statement$ + ":" = currentLine$ then
   'process line label here
   statement$ = statement$ + ":"
  end if
  statementCounter??? = statementCounter??? + 1
  ?#2, "'"; statement$
  xx = csrlin
  ?"Current line:    "; lineCounter???
  ?"Curent statement: ";
  if len(statement$) <= 62 then
   ?statement$; string$(62 - len(statement$), 32)
  else
   ?left$(statement$, 59); "..."
  end if
  locate xx, 1
  GetWord statement$, word$, " ", 1, dummy
  p = instr(statement$, word$) + len(word$) + 1
  if p > len(statement$) then
   arg$ = ""
  else
   arg$ = mid$(statement$, p, len(statement$) - p + 1)
  end if
  argLow$ = lcase$(arg$)
  word$ = lcase$(word$)
  'evaluate the first word in the statement...
  if left$(word$, 1) = "'" or left$(word$, 1) = "rem" then
   'it's a comment...
   commentCounter??? = commentCounter??? + 1
   iterate
  end if
  'now here's where the magic happens...
  flag = 0
  for a = 1 to 1023
   if jumps$(a) = word$ then
    gosub dword jumps???(a)
    flag = 1
    exit for
   end if
  next
  'Here we check for certain 'stand-alone' statements that would be missed
  'by the above routine, such as the implied 'let' (e.g. thisVariable = 9)
  'and line labels, and such...
  if right$(statement$, 1) = ":" then
   'this puts a terminate thread call after the end of the main procedure
   if endInserted = 0 then
    ?#2, "'end of main module, terminate thread code
    gosub process_system
    endInserted = 1
   end if
   ?#2, statement$
   flag = 1
  end if
  argLow$ = lcase$(statement$)
  GetWord statement$, word2$, " ", 2, dummy
  if word2$ = "=" then
   GetWord statement$, a$, " ", 2, dummy
   if a$ <> "=" then
    errText$ = "Expected '='."
    error 2
   end if
   GetWord statement$, a$, " ", 1, dummy
   WriteMovToFile argLow$, "bx"
   flag = 1
  end if
  'and this handles implied sub calls (e.g. main 99, y, 4)
  GetWord statement$, a$, " ", 1, dummy
  GetObjNumber "sub_" + lcase$(a$), objNum, 0
  if objNum <> 0 then
   GetWord objList$(objNum), numArgs$, " ", 3, dummy
   numArgs = val(numArgs$)
   'first we push the parameters onto the stack...
   subCounter = 2
   b$ = " "
   do until b$ = ""
    GetWord statement$, b$, " ", subCounter, dummy
    if b$ <> "" then
     StripChars b$, arg1$, ","
     WriteMovToFile arg1$, "us"
     ?#2, "push us"
    end if
    incr subCounter
   loop
   'we have to check for a parameter error...
   if subCounter - 3 <> numArgs then
    errText$ = "Wrong number of parameters."
    error 2
   end if
   'then we make the call...
   ?#2, "call "; a$
   'then we pop the parameters back off the stack...
   subCounter = numArgs + 1
   b$ = " "
   do until b$ = ""
    GetWord statement$, b$, " ", subCounter, dummy
    if b$ <> "" then
     incr popCounter
     ?#2, "pop us"
     StripChars b$, arg1$, ","
     GetObjNumber lcase$(b$), objNum, 0
     if objNum <> 0 then
      GetWord objList$(objNum), z$, " ", 3, dummy
      ?#2, "mov ["; z$; "], us"
     end if
    end if
    decr subCounter
    if popCounter = numArgs then exit loop
   loop
   flag = 1
  end if
  if flag = 0 then
   error 2
  end if
  if writeStr$ <> "" then ?#2, writeStr$
 loop
loop

'this line makes sure that there's and end to the program so the kernel won't
'go merrily on executing code past the end of the source code file
if endInserted = 0 then gosub process_system

gosub IncludeRoutines
gosub WrapUpFiles


?:?:?
?"Compile complete, program exiting."
?"Lines:", lineCounter???
?"Statements:", statementCounter???
?"Comments:", commentCounter???
system





IncludeRoutines:
 if includeSleepHandler = 1 then
  ?#2, "'compiler installed routine to handle SLEEP function:"
  ?#2, "SleepHandler:"
  ?#2, "mov ax, 0x60"
  ?#2, "mov dx, &SleepHandlerEnd"
  ?#2, "in bx, ax"
  ?#2, "SleepHandlerLoop:"
  ?#2, "in cx, ax"
  ?#2, "jmpn bx, cx, dx"
  ?#2, "jmp SleepHandlerLoop"
  ?#2, "SleepHandlerEnd:"
  ?#2, "ret"
 end if
return





WrapUpFiles:
 'This is where we write a bunch of empty data instructions to allow space
 'for the PBASIC program's variables. We also add instructions before the
 'beginning of the program to write over the jmp instruction so that we have
 'everything initialized to 0.
 close
 finalFile$ = cmdParent$ + "\" + n$ + ".asm"
 open newFile$ for input as #1
 open finalFile$ for output as #2
 'write header data...
 ?#2, "'Source file: "; file$
 ?#2, "'Compiled on "; date$; " at "; time$
 ?#2, ""
 ?#2, "' data statements to allocate memory for program variables..."
 ?#2, "jmp ProgramBegin"
 GetWord objList$(objListCounter), z$, " ", 3, dummy
 memTop??? = val(z$)
 for a = 1 to memTop??? - 4
  ?#2, "data 0x00"
 next
 ?#2, "ProgramBegin:"
 ?#2, "mov ax, 0"
 ?#2, "mov [0], ax"
 ?#2, "mov [4], ax"
 do while not eof(1)
  line input #1, a$
  ?#2, a$
 loop
 close
 kill cmdParent$ + "\temp.asm"
return





GetNextStatement:
 statementCounter = statementCounter + 1
 GetWord currentLine$, statement$, ":", statementCounter, dummy
 statement$ = ltrim$(rtrim$(statement$))
 'now we detect if we're at the end of this line or if we've got a whole
 'line comment...
 if statement$ = "" or left$(statement$, 1) = "'" then
  if not eof(1) then
   line input #1, currentLine$
   lineCounter??? = lineCounter??? + 1
   statementCounter = 0
   GetWord currentLine$, statement$, ":", counter, dummy
   statement$ = ltrim$(rtrim$(statement$))
  end if
 end if
 'now we strip off the comment part of the line, if any...
 b$ = ""
 quoteSuspend = 0
 for a = 1 to len(statement$)
  a$ = mid$(statement$, a, 1)
  if a$ = "'" and quoteSuspend = 0 then exit for
  if a$ = chr$(34) then quoteSuspend = 1 - quoteSuspend
  b$ = b$ + a$
 next
 statement$ = b$
 if left$(statement$, 1) = "?" then
  statement$ = "? " + right$(statement$, len(statement$) - 1)
 end if
return





compileError:
?:?:?
?"ObjList dump: (debugging only- remove)"
if err = 2 then
 color 4
 ?"Current line:    "; lineCounter???
 ?"Curent statement: ";
 if len(statement$) <= 62 then
  ?statement$; string$(62 - len(statement$), 32)
 else
  ?left$(statement$, 59); "..."
 end if
 ?"Syntax error. Compile halted."
 ?errText$
 color 7
 if endInserted = 0 then gosub process_system
 gosub IncludeRoutines
 gosub WrapUpFiles
 sleep
 for a = 1 to objListCounter
  ?objList$(a)
 next
 system
else
 ?"An error of type"; err; "has occurred at address"; rtrim$(str$(eradr)); "."
 system
end if
resume next





'------------------------------------------
'--------STATEMENT SUPPORT ROUTINES--------
'------------------------------------------





process_exit_dispatch:
 GetWord arg$, arg1$, " ", 1, dummy
 if arg1$ = "sub" then gosub process_end_sub
return





process_locate:
 GetWord arg$, arg1$, " ", 1, dummy
 StripChars arg1$, arg1$, ","
 if ltrim$(arg1$) <> "" then WriteMovToFile "*cursorV = " + arg1$, "ax"
 GetWord arg$, arg1$, " ", 2, dummy
 StripChars arg1$, arg1$, ","
 if ltrim$(arg1$) <> "" then WriteMovToFile "*cursorH = " + arg1$, "ax"
return





process_if:
 a$ = " "
 arg1$ = ""
 counter = 1
 do while a$ <> ""
  GetWord arg$, a$, " ", counter, dummy
  select case lcase$(a$)
   case = "then"
    GetWord arg1$, a$, " ", 1, dummy
    WriteMovToFile a$, "bx"

    GetWord arg1$, a$, " ", 3, dummy
    WriteMovToFile a$, "cx"

    GetWord arg1$, a$, " ", 2, dummy
    select case a$
     case = "="
      ?#2, "jmpe bx, cx, dx"
     case = "<>"
      ?#2, "jmpn bx, cx, dx"
     case = "<"
      ?#2, "jmpl bx, cx, dx"
     case = ">"
      ?#2, "jmpg bx, cx, dx"
     case = "=>", ">="
      ?#2, "jmpe bx, cx, dx"
      ?#2, "jmpg bx, cx, dx"
     case = "=<", "<="
      ?#2, "jmpe bx, cx, dx"
      ?#2, "jmpl bx, cx, dx"
    end select
    ?#2, "jmpe bx, cx, dx"
    cls
    ?arg1$
    sleep
    arg1$ = ""

   case = "or"
   case = "and"
   case else
    arg1$ = arg1$ + " " + a$
  end select
  incr counter
 loop
return





process_goto:
 GetObjNumber arg$ + ":", objNum, 0
 if objNum = 0 then
  errText$ = "Undefined line label."
  error 2
 end if
 ?#2, "jmp "; arg$
return





process_gosub:
 GetObjNumber lcase$(arg$) + ":", objNum, 0
 if objNum = 0 then
  errText$ = "Undefined line label."
  error 2
 end if
 ?#2, "call "; arg$
return





process_return:
 ?#2, "ret"
return





process_end_dispatch:
 GetWord arg$, arg1$, " ", 1, dummy
 if arg1$ = "" then gosub process_system
 if arg1$ = "sub" then gosub process_end_sub
return





process_end_sub:
 a$ = " "
 counter = 1
 ?#2, "pop ur"
 do until a$ = ""
  GetWord subStack$, a$, " ", counter, dummy
  if a$ <> "" then
   ?#2, "mov us, ["; a$; "]"
   ?#2, "push us"
   incr counter
  end if
 loop
 ?#2, "push ur"
 ?#2, "ret"
return





process_print:
 counter = 1
 arg1$ = " "
 do until arg1$ = ""
  GetWord arg$, arg1$, ";,", counter, where
  if left$(arg1$, 1) = chr$(34) and right$(arg1$, 1) <> chr$(34) then
   'this compensates if we cut a string literal in half by its comma...
   x$ = mid$(arg$, where + len(arg1$), 1)
   incr counter
   GetWord arg$, a$, ";,", counter, where
   arg1$ = arg1$ + x$ + a$
  end if
  arg1$ = ltrim$(rtrim$(arg1$))
  if arg1$ <> "" then
   if left$(arg1$, 1) = chr$(34) then
    arg1$ = ltrim$(rtrim$(arg1$, chr$(34)), chr$(34))
    arg1$ = mkwrd$(len(arg1$)) + arg1$
    do while (len(arg1$)) / 4 <> int((len(arg1$)) / 4)
     arg1$ = arg1$ + chr$(0)
    loop
    ?#2, "mov si, ip"
    ?#2, "mov ax, 28"
    ?#2, "add si, ax, si"
    ?#2, "mov ax, "; len(arg1$)
    ?#2, "add ip, ax, ip"
    for b = 1 to len(arg1$)
     b$ = hex$(asc(mid$(arg1$, b, 1)))
     PadHex b$, 2
     ?#2, "data 0x"; b$
    next
    ?#2, "mov ax, 0x07"
   else
    WriteMovToFile arg1$, "si"
    ?#2, "mov ax, 0x09"
   end if
   GetObjNumber "*cursorV", objNum, 1
   GetWord objList$(objNum), z$, " ", 3, dummy
   ?#2, "mov bx, ["; z$; "]"
   GetObjNumber "*cursorH", objNum, 1
   GetWord objList$(objNum), z$, " ", 3, dummy
   ?#2, "mov cx, ["; z$; "]"
   ?#2, "int 0x19"
  end if
  incr counter
 loop
return





process_pset:
 arg1$ = ""
 arg2$ = ""
 extra$ = ""
 for a = 1 to len(argLow$)
  a$ = mid$(argLow$, a, 1)
  if a$ = "(" then pCount = pCount + 1
  if a$ = ")" then pCount = pCount - 1
  if pCount = 0 then
   if arg1$ = "" then arg1$ = ca$:ca$ = "":iterate
   extra$ = extra$ + a$
  else
   if a$ <> "(" then ca$ = ca$ + a$
  end if
 next
 clr$ = ltrim$(right$(extra$, len(extra$) - 1))
 GetWord arg1$, arg1H$, ",", 1, dummy
 GetWord arg1$, arg1V$, ",", 2, dummy
 ?#2, "mov ax, 0x31"
 WriteMovToFile arg1H$, "bx"
 WriteMovToFile arg1V$, "cx"
 WriteMovToFile clr$, "fx"
 ?#2, "int 0x19"
return





process_sleep:
 'this is a function that'll take some assembly coding, and we don't wanna
 'include it and bloat the object code if it's never used, so here we set a
 'flag to remind us later to install an assembly routine to handle all the
 'occurrances of this statement in the program
 includeSleepHandler = 1
 ?#2, "call sleepHandler"
return





process_line:
 arg1$ = ""
 arg2$ = ""
 extra$ = ""
 for a = 1 to len(argLow$)
  a$ = mid$(argLow$, a, 1)
  if a$ = "(" then pCount = pCount + 1
  if a$ = ")" then pCount = pCount - 1
  if pCount = 0 then
   if arg1$ = "" then arg1$ = ca$:ca$ = "":iterate
   if arg2$ = "" then arg2$ = ca$:ca$ = "":iterate
   extra$ = extra$ + a$
  else
   if a$ <> "(" then ca$ = ca$ + a$
  end if
 next
 extra$ = ltrim$(right$(extra$, len(extra$) - 1))
 GetWord arg1$, arg1H$, ",", 1, dummy
 GetWord arg1$, arg1V$, ",", 2, dummy
 GetWord arg2$, arg2H$, ",", 1, dummy
 GetWord arg2$, arg2V$, ",", 2, dummy
 GetWord extra$, clr$, ",", 1, dummy
 GetWord extra$, box$, ",", 2, dummy
 ?#2, "mov ax, 0x31"
 WriteMovToFile arg1H$, "bx"
 WriteMovToFile arg1V$, "cx"
 WriteMovToFile arg2H$, "dx"
 WriteMovToFile arg2V$, "ex"
 WriteMovToFile clr$, "fx"
 box$ = ltrim$(rtrim$(box$))
 if box$ = "" then ?#2, "mov gx, 0"
 if box$ = "b" then ?#2, "mov gx, 1"
 if box$ = "bf" then ?#2, "mov gx, 2"
 ?#2, "int 0x19"
return





process_sub:
 'this puts a terminate thread call after the end of the main procedure
 if endInserted = 0 then
  ?#2, "'end of main module, terminate thread code
  gosub process_system
  endInserted = 1
 end if
 GetWord arg$, currentProcName$, " ", 1, dummy
 ?#2, currentProcName$; ":"
 'this pops the return address off the stack so we can get to the parameter
 'data we need...
 ?#2, "pop, ur"
 GetWord arg$, arg1$, "(", 2, dummy
 StripChars arg1$, arg1$, ")"
 b$ = " "
 counter = 1
 do until b$ = ""
  GetWord arg1$, b$, ",", counter, dummy
  b$ = ltrim$(b$)
  if b$ <> "" then
   GetObjNumber b$, objNum, 1
   GetWord objList$(objNum), z$, " ", 3, dummy
   ?#2, "pop us"
   ?#2, "mov ["; z$; "], us"
   subStack$ = subStack$ + z$ + " "
  end if
  incr counter
 loop
 'now we push the return address back on...
 ?#2, "push ur"
return





process_next:
 o$ = left$(operator$, 1)
 fc$ = ltrim$(str$(cvdwd(right$(forStack$, 4))))
 if operator$ = "" then
  errText$ = "'Next without 'for'."
  error 2
 end if
 ?#2, "jmpe uo, up, ur"
 if stepArg$ <> "" then
  'if a step value has been specified, we need to add an extra check to make
  'sure the index var gets evaluated properly...
  if o$ = "+" then ?#2, "jmpg uo, up, ur"
  if o$ = "-" then ?#2, "jmpl uo, up, ur"
 end if
 if o$ = "+" then ?#2, "add uo, uq, uo"
 if o$ = "-" then ?#2, "sub uo, uq, uo"
 ?#2, "jmp forLoopBegin"; fc$
 ?#2, "LoopDone"; fc$; ":"
 operator$ = right$(operator$, len(operator$) - 1)
 forStack$ = left$(forStack$, len(forStack$) - 4)
 'these lines only need added if we're already in a for/next loop...
 if len(forStack$) > 0 then
  ?#2, "pop ur"
  ?#2, "pop uq"
  ?#2, "pop up"
  ?#2, "pop uo"
 end if
return





process_for:
 '-a check needs added here to see if all arguments are static and if so
 ' then we can unroll the loop in assembly to speed up the code execution
 '-known issue: does not properly handle a first argument which is larger
 ' than the second with a non-static step argument
 ' (e.g. for a = 9 to 3 step m)
 if forCounter??? = 4294967295 then
  errText$ = "You may not have more than 4,294,967,294 for/next loops in your program."
  error 2
 end if
 arg1$ = ""
 arg2$ = ""
 stepArg$ = ""
 counter = 1
 done = 0
 'these lines only need added if we're already in a for/next loop...
 if len(forStack$) > 0 then
  ?#2, "push uo"
  ?#2, "push up"
  ?#2, "push uq"
  ?#2, "push ur"
 end if
 'get the name of the index variable
 GetWord argLow$, indexVar$, " ", 1, dummy
 'make sure it's in the objlist
 GetObjNumber indexVar$, objNum, 1
 'check for the '='
 GetWord argLow$, a$, " ", 2, dummy
 if a$ <> "=" then
  errText$ = "Expected '='."
  error 2
 end if
 'get first argument...
 do
  GetWord argLow$, a$, " ", 2 + counter, dummy
  if a$ = "" then
   errText$ = "Expected 'to'."
   error 2
  end if
  if lcase$(a$) <> "to" then arg1$ = arg1$ + a$ + " "
  if lcase$(a$) = "to" then done = 1
  counter = counter + 1
 loop while done = 0
 'get second argument...
 done = 0
 do
  GetWord argLow$, a$, " ", counter + 2, dummy
  if a$ = "" or lcase$(a$) = "step" then
   done = 1
  else
   arg2$ = arg2$ + a$ + " "
  end if
  counter = counter + 1
 loop while done = 0
 'get step value (if any)...
 GetWord argLow$, a$, " ", counter + 1, dummy
 if lcase$(a$) = "step" then
  done = 0
  do
   GetWord argLow$, a$, " ", counter + 2, dummy
   if a$ = "" or lcase$(a$) = "step" then
    done = 1
   else
    stepArg$ = stepArg$ + a$ + " "
   end if
   counter = counter + 1
  loop while done = 0
 end if
 operator$ = operator$ + "+"
 if stepArg$ <> "" then
  if left$(stepArg$, 1) = "-" then operator$ = operator$ + "-"
 end if
 WriteMovToFile indexVar$ + " = " + arg1$, "uo"
 WriteMovToFile arg2$, "up"
 WriteMovToFile stepArg$, "uq"
 if len(forStack$) < 32764 then
  forStack$ = forStack$ + mkdwd$(forCounter???)
 else
  errText$ = "You may not nest for/next loops more than 8191 levels deep."
  error 2
 end if
 ?#2, "mov ur, &LoopDone"; ltrim$(str$(forCounter???))
 ?#2, "ForLoopBegin"; ltrim$(str$(forCounter???)); ":"
 GetObjNumber indexVar$, objNum, 0
 GetWord objList$(objNum), z$, " ", 3, dummy
 ?#2, "mov ["; z$; "], uo"
 incr forCounter???
return





process_system:
 ?#2, "mov ax, 8"
 ?#2, "mov bx, 0"
 ?#2, "int 0x19"
return





process_let:
 GetWord argLow$, a$, " ", 2, dummy
 if a$ <> "=" then
  errText$ = "Expected '='."
  error 2
 end if
 GetWord argLow$, a$, " ", 1, dummy
 WriteMovToFile argLow$, "bx"
return





process_shared:
 a$ = " "
 do while a$ <> ""
  GetWord argLow$, a$, ",", 1 + c, dummy
  a$ = ltrim$(rtrim$(a$))
  if a$ = "" then exit do
  GetObjNumber a$, objNum, 1
  incr c
 loop
 c = 0
return





process_type:
 userTypes$(userTypeCounter) = arglow$
 do while lcase$(statement$) <> "end type"
  gosub GetNextStatement
  GetWord statement$, word$, " ", 1, dummy
  if word$ <> "" and lcase$(word$) <> "end" then
   varName$ = word$
   GetWord statement$, word$, " ", 2, dummy
   if lcase$(word$) <> "as" then
    errText$ = "Expected 'as'."
    error 2
   end if
   GetWord statement$, word$, " ", 3, dummy
   WordToDataType word$, theType
   userTypes$(userTypeCounter) = userTypes$(userTypeCounter) + " " + varName$ + str$(theType)
  end if
 loop
return





process_defint:
 GetWord argLow$, w1$, " ", 1, dummy
 GetWord argLow$, w2$, " ", 2, dummy
 GetWord argLow$, w3$, " ", 3, dummy
 if len(w1$) = 3 and mid$(w1$, 2, 1) = "-" then
  w3$ = mid$(w1$, 3, 1)
  w2$ = mid$(w1$, 2, 1)
  w1$ = mid$(w1$, 1, 1)
 end if
 if w1$ <> "" and len(w1$) = 1 then
  rangeStart = asc(ucase$(w1$)) - 64
  if w2$ <> "" then
   if w2$ <> "-" then
    errText$ = "Expected '-'."
    error 2
   end if
   if w3$ <> "" then
    if len(w3$) = 1 then
     rangeEnd = asc(ucase$(w3$)) - 64
    end if
   else
    errText$ = "Operand expected."
    error 2
   end if
  end if
 else
  error 2
 end if
 if rangeEnd = 0 then rangeEnd = rangeStart
 if rangeEnd < rangeStart then
  errText$ = "Ending operand cannot be larger than beginning operand."
  error 2
 end if
 for a = rangeStart to rangeEnd
  varDefaults(a) = kInteger
 next
 rangeStart = 0
 rangeEnd = 0
return





process_deflng:
 GetWord argLow$, w1$, " ", 1, dummy
 GetWord argLow$, w2$, " ", 2, dummy
 GetWord argLow$, w3$, " ", 3, dummy
 if len(w1$) = 3 and mid$(w1$, 2, 1) = "-" then
  w3$ = mid$(w1$, 3, 1)
  w2$ = mid$(w1$, 2, 1)
  w1$ = mid$(w1$, 1, 1)
 end if
 if w1$ <> "" and len(w1$) = 1 then
  rangeStart = asc(ucase$(w1$)) - 64
  if w2$ <> "" then
   if w2$ <> "-" then
    errText$ = "Expected '-'."
    error 2
   end if
   if w3$ <> "" then
    if len(w3$) = 1 then
     rangeEnd = asc(ucase$(w3$)) - 64
    end if
   else
    errText$ = "Operand expected."
    error 2
   end if
  end if
 else
  error 2
 end if
 if rangeEnd = 0 then rangeEnd = rangeStart
 if rangeEnd < rangeStart then
  errText$ = "Ending operand cannot be larger than beginning operand."
  error 2
 end if
 for a = rangeStart to rangeEnd
  varDefaults(a) = kLong
 next
 rangeStart = 0
 rangeEnd = 0
return





process_defqud:
 GetWord argLow$, w1$, " ", 1, dummy
 GetWord argLow$, w2$, " ", 2, dummy
 GetWord argLow$, w3$, " ", 3, dummy
 if len(w1$) = 3 and mid$(w1$, 2, 1) = "-" then
  w3$ = mid$(w1$, 3, 1)
  w2$ = mid$(w1$, 2, 1)
  w1$ = mid$(w1$, 1, 1)
 end if
 if w1$ <> "" and len(w1$) = 1 then
  rangeStart = asc(ucase$(w1$)) - 64
  if w2$ <> "" then
   if w2$ <> "-" then
    errText$ = "Expected '-'."
    error 2
   end if
   if w3$ <> "" then
    if len(w3$) = 1 then
     rangeEnd = asc(ucase$(w3$)) - 64
    end if
   else
    errText$ = "Operand expected."
    error 2
   end if
  end if
 else
  error 2
 end if
 if rangeEnd = 0 then rangeEnd = rangeStart
 if rangeEnd < rangeStart then
  errText$ = "Ending operand cannot be larger than beginning operand."
  error 2
 end if
 for a = rangeStart to rangeEnd
  varDefaults(a) = kQuad
 next
 rangeStart = 0
 rangeEnd = 0
return





process_defsng:
 GetWord argLow$, w1$, " ", 1, dummy
 GetWord argLow$, w2$, " ", 2, dummy
 GetWord argLow$, w3$, " ", 3, dummy
 if len(w1$) = 3 and mid$(w1$, 2, 1) = "-" then
  w3$ = mid$(w1$, 3, 1)
  w2$ = mid$(w1$, 2, 1)
  w1$ = mid$(w1$, 1, 1)
 end if
 if w1$ <> "" and len(w1$) = 1 then
  rangeStart = asc(ucase$(w1$)) - 64
  if w2$ <> "" then
   if w2$ <> "-" then
    errText$ = "Expected '-'."
    error 2
   end if
   if w3$ <> "" then
    if len(w3$) = 1 then
     rangeEnd = asc(ucase$(w3$)) - 64
    end if
   else
    errText$ = "Operand expected."
    error 2
   end if
  end if
 else
  error 2
 end if
 if rangeEnd = 0 then rangeEnd = rangeStart
 if rangeEnd < rangeStart then
  errText$ = "Ending operand cannot be larger than beginning operand."
  error 2
 end if
 for a = rangeStart to rangeEnd
  varDefaults(a) = kSingle
 next
 rangeStart = 0
 rangeEnd = 0
return





process_defdbl:
 GetWord argLow$, w1$, " ", 1, dummy
 GetWord argLow$, w2$, " ", 2, dummy
 GetWord argLow$, w3$, " ", 3, dummy
 if len(w1$) = 3 and mid$(w1$, 2, 1) = "-" then
  w3$ = mid$(w1$, 3, 1)
  w2$ = mid$(w1$, 2, 1)
  w1$ = mid$(w1$, 1, 1)
 end if
 if w1$ <> "" and len(w1$) = 1 then
  rangeStart = asc(ucase$(w1$)) - 64
  if w2$ <> "" then
   if w2$ <> "-" then
    errText$ = "Expected '-'."
    error 2
   end if
   if w3$ <> "" then
    if len(w3$) = 1 then
     rangeEnd = asc(ucase$(w3$)) - 64
    end if
   else
    errText$ = "Operand expected."
    error 2
   end if
  end if
 else
  error 2
 end if
 if rangeEnd = 0 then rangeEnd = rangeStart
 if rangeEnd < rangeStart then
  errText$ = "Ending operand cannot be larger than beginning operand."
  error 2
 end if
 for a = rangeStart to rangeEnd
  varDefaults(a) = kDouble
 next
 rangeStart = 0
 rangeEnd = 0
return





process_defext:
 GetWord argLow$, w1$, " ", 1, dummy
 GetWord argLow$, w2$, " ", 2, dummy
 GetWord argLow$, w3$, " ", 3, dummy
 if len(w1$) = 3 and mid$(w1$, 2, 1) = "-" then
  w3$ = mid$(w1$, 3, 1)
  w2$ = mid$(w1$, 2, 1)
  w1$ = mid$(w1$, 1, 1)
 end if
 if w1$ <> "" and len(w1$) = 1 then
  rangeStart = asc(ucase$(w1$)) - 64
  if w2$ <> "" then
   if w2$ <> "-" then
    errText$ = "Expected '-'."
    error 2
   end if
   if w3$ <> "" then
    if len(w3$) = 1 then
     rangeEnd = asc(ucase$(w3$)) - 64
    end if
   else
    errText$ = "Operand expected."
    error 2
   end if
  end if
 else
  error 2
 end if
 if rangeEnd = 0 then rangeEnd = rangeStart
 if rangeEnd < rangeStart then
  errText$ = "Ending operand cannot be larger than beginning operand."
  error 2
 end if
 for a = rangeStart to rangeEnd
  varDefaults(a) = kExt
 next
 rangeStart = 0
 rangeEnd = 0
return





process_deffix:
 GetWord argLow$, w1$, " ", 1, dummy
 GetWord argLow$, w2$, " ", 2, dummy
 GetWord argLow$, w3$, " ", 3, dummy
 if len(w1$) = 3 and mid$(w1$, 2, 1) = "-" then
  w3$ = mid$(w1$, 3, 1)
  w2$ = mid$(w1$, 2, 1)
  w1$ = mid$(w1$, 1, 1)
 end if
 if w1$ <> "" and len(w1$) = 1 then
  rangeStart = asc(ucase$(w1$)) - 64
  if w2$ <> "" then
   if w2$ <> "-" then
    errText$ = "Expected '-'."
    error 2
   end if
   if w3$ <> "" then
    if len(w3$) = 1 then
     rangeEnd = asc(ucase$(w3$)) - 64
    end if
   else
    errText$ = "Operand expected."
    error 2
   end if
  end if
 else
  error 2
 end if
 if rangeEnd = 0 then rangeEnd = rangeStart
 if rangeEnd < rangeStart then
  errText$ = "Ending operand cannot be larger than beginning operand."
  error 2
 end if
 for a = rangeStart to rangeEnd
  varDefaults(a) = kFix
 next
 rangeStart = 0
 rangeEnd = 0
return





process_defbcd:
 GetWord argLow$, w1$, " ", 1, dummy
 GetWord argLow$, w2$, " ", 2, dummy
 GetWord argLow$, w3$, " ", 3, dummy
 if len(w1$) = 3 and mid$(w1$, 2, 1) = "-" then
  w3$ = mid$(w1$, 3, 1)
  w2$ = mid$(w1$, 2, 1)
  w1$ = mid$(w1$, 1, 1)
 end if
 if w1$ <> "" and len(w1$) = 1 then
  rangeStart = asc(ucase$(w1$)) - 64
  if w2$ <> "" then
   if w2$ <> "-" then
    errText$ = "Expected '-'."
    error 2
   end if
   if w3$ <> "" then
    if len(w3$) = 1 then
     rangeEnd = asc(ucase$(w3$)) - 64
    end if
   else
    errText$ = "Operand expected."
    error 2
   end if
  end if
 else
  error 2
 end if
 if rangeEnd = 0 then rangeEnd = rangeStart
 if rangeEnd < rangeStart then
  errText$ = "Ending operand cannot be larger than beginning operand."
  error 2
 end if
 for a = rangeStart to rangeEnd
  varDefaults(a) = kBcd
 next
 rangeStart = 0
 rangeEnd = 0
return





process_defstr:
 GetWord argLow$, w1$, " ", 1, dummy
 GetWord argLow$, w2$, " ", 2, dummy
 GetWord argLow$, w3$, " ", 3, dummy
 if len(w1$) = 3 and mid$(w1$, 2, 1) = "-" then
  w3$ = mid$(w1$, 3, 1)
  w2$ = mid$(w1$, 2, 1)
  w1$ = mid$(w1$, 1, 1)
 end if
 if w1$ <> "" and len(w1$) = 1 then
  rangeStart = asc(ucase$(w1$)) - 64
  if w2$ <> "" then
   if w2$ <> "-" then
    errText$ = "Expected '-'."
    error 2
   end if
   if w3$ <> "" then
    if len(w3$) = 1 then
     rangeEnd = asc(ucase$(w3$)) - 64
    end if
   else
    errText$ = "Operand expected."
    error 2
   end if
  end if
 else
  error 2
 end if
 if rangeEnd = 0 then rangeEnd = rangeStart
 if rangeEnd < rangeStart then
  errText$ = "Ending operand cannot be larger than beginning operand."
  error 2
 end if
 for a = rangeStart to rangeEnd
  varDefaults(a) = kString
 next
 rangeStart = 0
 rangeEnd = 0
return





process_defptr:
 GetWord argLow$, w1$, " ", 1, dummy
 GetWord argLow$, w2$, " ", 2, dummy
 GetWord argLow$, w3$, " ", 3, dummy
 if len(w1$) = 3 and mid$(w1$, 2, 1) = "-" then
  w3$ = mid$(w1$, 3, 1)
  w2$ = mid$(w1$, 2, 1)
  w1$ = mid$(w1$, 1, 1)
 end if
 if w1$ <> "" and len(w1$) = 1 then
  rangeStart = asc(ucase$(w1$)) - 64
  if w2$ <> "" then
   if w2$ <> "-" then
    errText$ = "Expected '-'."
    error 2
   end if
   if w3$ <> "" then
    if len(w3$) = 1 then
     rangeEnd = asc(ucase$(w3$)) - 64
    end if
   else
    errText$ = "Operand expected."
    error 2
   end if
  end if
 else
  error 2
 end if
 if rangeEnd = 0 then rangeEnd = rangeStart
 if rangeEnd < rangeStart then
  errText$ = "Ending operand cannot be larger than beginning operand."
  error 2
 end if
 for a = rangeStart to rangeEnd
  varDefaults(a) = kPtr
 next
 rangeStart = 0
 rangeEnd = 0
return





process_declare:
 if left$(argLow$, 4) = "sub " then
  z = csrlin
  ?:?:?
  color 14
  ?"NOTE: Use of 'declare sub' is not neccessary."
  sleep 1
  locate z + 3
  ?string$(45, 32)
  color 7
  locate z
 end if
return





process_timer:
 if argLow$ = "on" or argLow$ = "stop" or argLow$ = "off" then
  color 14
  ?"NOTE: Use of 'timer "; argLow$; "' is not supported."
  color 7
 end if
return





process_screen:
 ?#2, "mov ax, 6"
 GetWord statement$, word$, " ", 2, dummy
 WriteMovToFile argLow$, "bx"
 ?#2, "int 0x19"
return





process_cls:
 ?#2, "mov ax, 5"
 ?#2, "int 0x19"
return





'------------------------------------------
'----------MAIN ROUTINE ENDS HERE----------
'------------------------------------------





sub InitJumps
 jumps$(1) = "screen":jumps???(1) = codeptr32(process_screen)
 jumps$(2) = "cls":jumps???(2) = codeptr32(process_cls)
 jumps$(3) = "declare":jumps???(3) = codeptr32(process_declare)
 jumps$(4) = "timer":jumps???(4) = codeptr32(process_timer)
 jumps$(5) = "defint":jumps???(5) = codeptr32(process_defint)
 jumps$(6) = "deflng":jumps???(6) = codeptr32(process_deflng)
 jumps$(7) = "defqud":jumps???(7) = codeptr32(process_defqud)
 jumps$(8) = "defsng":jumps???(8) = codeptr32(process_defsng)
 jumps$(9) = "defdbl":jumps???(9) = codeptr32(process_defdbl)
 jumps$(10) = "defext":jumps???(10) = codeptr32(process_defext)
 jumps$(11) = "deffix":jumps???(11) = codeptr32(process_deffix)
 jumps$(12) = "defbcd":jumps???(12) = codeptr32(process_defbcd)
 jumps$(13) = "defptr":jumps???(13) = codeptr32(process_defptr)
 jumps$(14) = "defstr":jumps???(14) = codeptr32(process_defstr)
 jumps$(15) = "type":jumps???(15) = codeptr32(process_type)
 jumps$(16) = "shared":jumps???(16) = codeptr32(process_shared)
 jumps$(17) = "let":jumps???(17) = codeptr32(process_let)
 jumps$(18) = "system":jumps???(18) = codeptr32(process_system)
 jumps$(19) = "end":jumps???(19) = codeptr32(process_end_dispatch)
 jumps$(20) = "for":jumps???(20) = codeptr32(process_for)
 jumps$(21) = "next":jumps???(21) = codeptr32(process_next)
 jumps$(22) = "sub":jumps???(22) = codeptr32(process_sub)
 jumps$(23) = "line":jumps???(23) = codeptr32(process_line)
 jumps$(24) = "sleep":jumps???(24) = codeptr32(process_sleep)
 jumps$(25) = "pset":jumps???(25) = codeptr32(process_pset)
 jumps$(26) = "print":jumps???(26) = codeptr32(process_print)
 jumps$(27) = "return":jumps???(27) = codeptr32(process_return)
 jumps$(28) = "gosub":jumps???(28) = codeptr32(process_gosub)
 jumps$(29) = "goto":jumps???(29) = codeptr32(process_goto)
 jumps$(30) = "if":jumps???(30) = codeptr32(process_if)
 jumps$(31) = "locate":jumps???(31) = codeptr32(process_locate)
 jumps$(32) = "?":jumps???(32) = codeptr32(process_print)
 jumps$(33) = "exit":jumps???(33) = codeptr32(process_exit_dispatch)
end sub





defint a-z
sub GetObjNumber (objN$, objNum, autoAdd)
 'This function returns the number of an object in the object list. If the
 'object is not found, it will be added if autoAdd is nonzero.
 if objN$ = "" then exit sub
 objName$ = lcase$(objN$)
 objNum = 0
 for a = 1 to objListCounter
  GetWord objList$(a), word$, " ", 1, dummy
  GetTypeBySymbol objName$, theType
  if theType = kSUB or theType = kLineLabel then
   if word$ = objName$ then objNum = a:exit sub
  end if
  if word$ = currentProcName$ + ":" + objName$ then objNum = a:exit sub
  if word$ = "" then objNum = a:exit for
 next
 if autoAdd <> 0 then
  incr objListCounter
  objNum = objListCounter
  GetTypeBySymbol objName$, theType
  'if theType = 0 then theType = varDefaults(asc(lcase$(left$(objName$, 1))) - 96)
  if theType = 0 then theType = kDWord
  if theType = kSUB or theType = kLineLabel then
   objList$(objListCounter) = lcase$(objName$ + " " + str$(theType)) + " " + str$(autoAdd)
  else
   objList$(objListCounter) = lcase$(currentProcName$ + ":" + objName$ + " " + str$(theType) + " " + str$(nextAddress???))
   nextAddress??? = nextAddress??? + varSize(theType)
  end if
 end if
end sub





defint a-z
sub WriteMovToFile (theArg$, register$)
 'This function does the math for an instruction. It calculates whether
 'the item specified is a literal number or a variable and figures the result
 'accordingly.
 argument$= ltrim$(rtrim$(theArg$))
 if argument$ = "" then exit sub
 'set letFlag if this is an assignment statement...
 GetWord argument$, y$, " ", 2, dummy
 if y$ = "=" then letFlag = 1
 'zero the target register before we begin...
 ?#2, "mov "; register$; ", 0"
 'force one pass through this loop...
 y$ = " "
 do until y$ = ""
  GetWord argument$, y$, " ", 1 + counter, dummy
  select case y$
   case = "+":nextInst$ = "add"
   case = "-":nextInst$ = "sub"
   case = "*":nextInst$ = "mul"
   case = "/":nextInst$ = "div"
   case = "\":nextInst$ = "div"
   case = "^":nextInst$ = "exp"
   case = "=":nextInst$ = "add"
   case else
    IsDigit y$, d
    if d = 1 then
     ?#2, "mov us, "; y$
     'make sure expressions beginning with numbers get properly handled...
     if counter = 0 then nextInst$ = "add"
    else
     if y$ <> "" then
      GetObjNumber y$, objNum, 1
      GetWord objList$(objNum), z$, " ", 3, dummy
      if addr$ = "" then
       if letFlag = 1 then
        addr$ = z$
       else
        ?#2, "mov us, ["; z$; "]"
        if nextInst$ = "" then nextInst$ = "add"
       end if
      else
       ?#2, "mov us, ["; z$; "]"
      end if
     else
     end if
    end if
    if nextInst$ <> "" and y$ <> "" then
     ?#2, nextInst$; " "; register$; ", us, "; register$
    end if
  end select
  incr counter
 loop
 if addr$ <> "" then ?#2, "mov ["; addr$; "], "; register$
end sub





defint a-z
sub GetTypeBySymbol (varName$, theType)
 'This function returns the type a variable should be based on the suffix in
 'its name. It will return 0 if there is no suffix.
 theType = 0
 for a = len(varName$) to 1 step - 1
  y$ = lcase$(mid$(varName$, a, 1))
  if instr("?%&!#@$", any y$) <> 0 then
   x$ = y$ + x$
  else
   exit for
  end if
 next
 select case x$
  case = "?":theType = kByte
  case = "??":theType = kWord
  case = "%":theType = kInteger
  case = "???":theType = kDword
  case = "&":theType = kLong
  case = "&&":theType = kQuad
  case = "!":theType = kSingle
  case = "#":theType = kDouble
  case = "##":theType = kExt
  case = "@":theType = kFix
  case = "@@":theType = kBcd
  case = "@":theType = kPtr
  case = "$":theType = kString
 end select
 if ltrim$(lcase$(left$(varName$, 3))) = "sub" then theType = kSUB
 if right$(varName$, 1) = ":" then theType = kLineLabel
end sub





defint a-z
sub WordToDataType (theType$, theType)
 select case lcase$(theType$)
  case = "byte":theType = kByte
  case = "word":theType = kWord
  case = "integer":theType = kInteger
  case = "dword":theType = kDword
  case = "long":theType = kLong
  case = "quad":theType = kQuad
  case = "single":theType = kSingle
  case = "double":theType = kDouble
  case = "ext":theType = kExt
  case = "fix":theType = kFix
  case = "bcd":theType = kBcd
  case = "ptr":theType = kPtr
  case = "string":theType = kString
  case else:theType = kUserDefined
 end select
end sub





SUB IsDigit (char$, digit)
 digit = 0
 IF char$ = "" THEN exit sub
 IF left$(char$, 2) = "0x" then
  numSet$ = "0123456789ABCDEFabcdef"
  startChr = 3
 else
  numSet$ = "0123456789"
  startChr = 1
 end if
 for a = startChr to len(char$)
  a$ = mid$(char$, a, 1)
  if instr(a$, any numSet$) = 0 then exit sub
 next
 digit = 1
END SUB





DEFINT A-Z
SUB GetWord (a$, word$, sep$, w, strWhere)
 'this routine returns a certain word out of a string divided into words
 'by sep$, which can be a list of characters or a single character, and
 'returns the position where it found the specified word in strWhere
 word$ = ""
 IF a$ = "" THEN EXIT SUB
 for a = 1 to len(a$)
  b$ = mid$(a$, a, 1)
  if instr(b$, any sep$) = 1 then
   if instr(lastChar$, any sep$) = 0 then
    aa$ = aa$ + b$
   end if
  else
   aa$ = aa$ + b$
  end if
  lastChar$ = b$
 next
 aa$ = aa$ + left$(sep$, 1)
 for a = 1 to len(aa$)
  b$ = mid$(aa$, a, 1)
  if instr(b$, any sep$) = 1 then
   d$ = c$
   c$ = ""
   word = word + 1
   if word = w then
    word$ = d$
    strWhere = a - len(d$)
    exit sub
   end if
  else
   c$ = c$ + b$
  end if
 next
END SUB





SUB LastOfFSpec (fspec$, n$)
 n$ = ""
 FOR a = LEN(fspec$) TO 1 STEP -1
  c$ = MID$(fspec$, a, 1)
  IF c$ <> "\" THEN n$ = c$ + n$ ELSE EXIT SUB
 NEXT
END SUB





DEFINT A-Z
SUB SplitFilename (fileName$, flName$, ext$)
 flName$ = ""
 ext$ = ""
 FOR a = 1 TO LEN(fileName$)
  a$ = MID$(fileName$, a, 1)
  IF a$ <> "." THEN
   flName$ = flName$ + a$
  ELSE
   EXIT FOR
  END IF
 NEXT
 FOR a = 1 TO LEN(fileName$)
  IF MID$(fileName$, a, 1) = "." THEN flag = 1
 NEXT
 IF flag = 1 THEN
  FOR a = LEN(fileName$) TO 1 STEP -1
   a$ = MID$(fileName$, a, 1)
   IF a$ <> "." THEN
    ext$ = a$ + ext$
   ELSE
    EXIT FOR
   END IF
  NEXT
 END IF
 ext$ = LTRIM$(RTRIM$(ext$))
 IF ext$ <> "" AND RIGHT$(ext$, 1) = CHR$(0) THEN ext$ = LEFT$(ext$, LEN(ext$) - 1)
END SUB





DEFSNG A-Z
SUB GetParentPath (p$, ppath$)
 path$ = p$
 IF RIGHT$(path$, 1) = "\" THEN path$ = LEFT$(path$, LEN(path$) - 1)
 ppath$ = path$
 FOR a = LEN(path$) TO 1 STEP -1
  IF RIGHT$(ppath$, 1) <> "\" THEN
   ppath$ = LEFT$(ppath$, LEN(ppath$) - 1)
  ELSE
   ppath$ = LEFT$(ppath$, LEN(ppath$) - 1)
   EXIT FOR
  END IF
 NEXT
END SUB





DEFINT A-Z
SUB PadHex(value$, length)
 if len(value$) >= length then exit sub
 do until len(value$) = length
  value$ = "0" + value$
 loop
END SUB





defint a-z
sub StripChars(inputStr$, outputStr$, stripChr$)
 for a = 1 to len(inputStr$)
  a$ = mid$(inputStr$, a, 1)
  if a$ <> stripChr$ then b$ = b$ + a$
 next
 outputStr$ = b$
end sub