'PCOS Kernel Display Module (dispmod.bas) version 2.0
'Copyright 1995-2008 by Mercury0x000D

'dispmod.bas is a part of the PCOS Kernel

'The PCOS Kernel is free software: you can redistribute it and/or modify
'it under the terms of the GNU General Public License as published by
'the Free Software Foundation, either version 3 of the License, or
'(at your option) any later version.

'The PCOS Kernel is distributed in the hope that it will be useful,
'but WITHOUT ANY WARRANTY; without even the implied warranty of
'MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
'GNU General Public License for more details.

'You should have received a copy of the GNU General Public License
'along with the PCOS Kernel.  If not, see <http://www.gnu.org/licenses/>.

'See the included file <GPL License.txt> for the complete text of the 
'GPL License by which this program is covered.


'credits:
'The PCOS Kernel Display Module was developed using modified versions
'of the following public domain code by the following people:
'GIF support			MakeGIF & LoadGIF, 1992 by Rich Geldreich
'shape drawing routines		svgalib.bas by Aaron Severn (Laeden) 1997





defint a-z
option binary base 1

'XMS Manager globals
type xmsVarType
 '16 bytes
 size as dword
 sourceHandle as word
 sourceOffset as dword
 destHandle as word
 destOffset as dword
end type
dim xmsVar as xmsVarType
shared xmsDriverAddr???, xmsVar, xmsDriverSeg??, xmsDriverPtr??



'globals for display manager...
TYPE pix2type
 y AS INTEGER
 xl AS INTEGER
 xr AS INTEGER
 dy AS INTEGER
END TYPE

TYPE bitmapFileHeader
 bfType AS STRING * 2
 bfSize AS LONG
 bfReserved1 AS INTEGER
 bfReserved2 AS INTEGER
 bfOffBits AS LONG
END TYPE

TYPE bitmapInfoHeader
 biSize AS LONG
 biWidth AS LONG
 biHeight AS LONG
 biPlanes AS INTEGER
 biBitCount AS INTEGER
 biCompression AS LONG
 biSizeImage AS LONG
 biXPelsPerMeter AS LONG
 biYPelsPerMeter AS LONG
 biClrUsed AS LONG
 biClrImportant AS LONG
END TYPE

TYPE PCXHeader
 manufacturer as byte
 version as byte
 encoding as byte
 bitsPerPixel as byte
 xmin as integer
 ymin as integer
 xmax as integer
 ymax as integer
 hres as integer
 vres as integer
 colormap as string * 48
 reserved1 as byte
 planes as byte
 bytesPerLine as integer
 paletteInfo as integer
 filler as string * 58
END TYPE

type theRect
 tlh as integer
 tlv as integer
 brh as integer
 brv as integer
end type

type thePoint
 h as integer
 v as integer
end type

dim pt as thePoint
dim rect as theRect
shared rect, pt
shared xRes, yRes, yOffset&, curBank, winGran

dim fa?(0 to 2047)
dminitromfont fa?()



'init xms...
XMInit success, dummy, dummy
if success = 0 then ?"no xms available":system


'init vesa...
DMGetVESAData VESAPresent, OEMStr$, vmajor, vminor, vram???

IF VESAPresent THEN                             'Check for VESA
 DMSetMode &h105, success
 IF success = 0 THEN                            'Check for/set screen mode
  PRINT "Error:  Screen mode not available."    'Shut down if mode is not
  SYSTEM                                        'available
 END IF
ELSE
 PRINT "Error:  VESA not supported."            'Shut down if VESA is not
 SYSTEM                                         'present
END IF


th = 5
tv = 5
dc = 99
tx$ = "Hello, world."

wide?? = 3072
high?? = 2304

DM8NewPixmap handle1???, 1024, 768
if handle1??? = 0 then system
DM8NewPixmap handle2???, wide??, high??
if handle2??? = 0 then system
DM8NewPixmap handle3???, 128, 128
if handle3??? = 0 then system
DM8DrawLine handle3???, 0, 0, 127, 127, 99
DM8DrawLine handle3???, 127, 0, 0, 127, 99

dm8loadbmp handle2???, 0, 0, "sample.bmp"

scramt = 32
rect.tlh = 0
rect.tlv = 0
rect.brh = 1023
rect.brv = 767
pt.h =  0
pt.v = 0

dim rect2 as therect, pt2 as thepoint
rect2.tlh = 0
rect2.tlv = 0
rect2.brh = 127
rect2.brv = 127
pt2.h =  0
pt2.v = 0

DM8CopyPixmap handle2???, handle1???, rect, pt
DM8CopyPixmapClear handle3???, handle1???, rect2, pt2, 0

'dm8blittovram640x480 handle1???
'dm8blittovram800x600 handle1???
dm8blittovram1024x768 handle1???

do while a <> 1
 flag = 0
 a$ = inkey$: a$ = inkey$: a$ = inkey$: a$ = inkey$: a$ = inkey$
 a$ = inkey$: a$ = inkey$: a$ = inkey$: a$ = inkey$: a$ = inkey$
 a = inp(96)
 t1! = timer
 if t1! >= t2! + 1 then
  if fc > hf then hf = fc
  fc = 0
  t2! = timer
 end if
 if a = 32 then
  'disable vtrace wait
  vtrace = 0
  for b = 1500 to 2500 step 10
   sound b, .01
  next
 end if
 if a = 18 then
  'enable vtrace wait
  vtrace = 1
  for b = 2500 to 1500 step -10
   sound b, .01
  next
 end if
 if a = 72 then
  rect.tlv = rect.tlv - scramt
  if rect.tlv < 0 then
   rect.tlv = 0
  else
   rect.brv = rect.brv - scramt
  end if
  flag = 1
 end if
 if a = 80 then
  rect.brv = rect.brv + scramt
  if rect.brv > high?? - 1 then
   rect.brv = high?? - 1
  else
   rect.tlv = rect.tlv + scramt
  end if
  flag = 1
 end if
 if a = 75 then
  rect.tlh = rect.tlh - scramt
  if rect.tlh < 0 then
   rect.tlh = 0
  else
   rect.brh = rect.brh - scramt
  end if
  flag = 1
 end if
 if a = 77 then
  rect.brh = rect.brh + scramt
  if rect.brh > wide?? - 1 then
   rect.brh = wide?? -1
  else
   rect.tlh = rect.tlh + scramt
  end if
  flag = 1
 end if
 if flag = 1 then
  DM8CopyPixmap handle2???, handle1???, rect, pt
  DM8CopyPixmapClear handle3???, handle1???, rect2, pt2, 0
  DMPrint handle1???, fa?(), th, tv, tx$, dc
  incr fc
  'dm8blittovram640x480 handle1???
  'dm8blittovram800x600 handle1???
  dm8blittovram1024x768 handle1???
  if vtrace = 1 then DMWaitForVtrace
 end if
loop
rect.tlh = 0
rect.tlv = 0
rect.brh = 639
rect.brv = 479
DM8SaveGIF handle1???, rect, "new.gif"
dmclosevesamode
'show top FPS and exit
?hf
sleep
cls
system





'------------------------
'Display Module functions
'display.bas	v2.0
'------------------------





defint a-z
sub DMGetVESAData (VESAPresent, OEMStr$, VESAMajorVer, VESAMinorVer, VideoRAM???)
 xdv = 0
 VESAPresent = 0
 DIM VESAInfo(127)
 vseg = VARSEG(VESAInfo(0))
 vptr = VARPTR(VESAInfo(0))
 !mov ax, &h4F00
 !mov es, vseg
 !mov di, vptr
 !int &h10
 !mov xdv, ax
 IF xdv = &h4F THEN
  VESAPresent = 1
  def seg = vseg
  VESAMinorVer = peek(4)
  VESAMajorVer = peek(5)
  OEMStrPtr = VESAInfo(3)
  OEMStrSeg = VESAInfo(4)
  def seg = OEMStrSeg
  for a = OEMStrPtr to OEMStrPtr + 255
   b = peek(a)
   if b <> 0 then
    OEMStr$ = OEMStr$ + chr$(b)
   else
    exit for
   end if
  next
  VideoRAM??? = VESAInfo(9) * 64
  end if
end sub





defint a-z
sub DMSetMode (mode, successFlag)
 zax = 0
 zmode = mode
 successFlag = 0
 DIM modeInfo(127)
 vseg = VARSEG(modeInfo(0))
 vptr = VARPTR(modeInfo(0))
 !mov ax, &h4F01
 !mov cx, zmode
 !mov es, vseg
 !mov di, vptr
 !int &h10
 xRes = modeinfo(9)
 yRes = modeinfo(10)
 def seg = vseg
 x = peek(30)
 !mov ax, &h4F02
 !mov bx, zmode
 !int &h10
 !mov zax, ax
 IF zax = &h4F THEN
  winGran = 64 \ modeInfo(2)
  curBank = 0
  yOffset& = 0
  successFlag = 1
 end if
end sub





defint a-z
SUB DM8SetActivePage (page)
 yOffset& = yRes * page
END SUB





defint a-z
SUB DM8SetDisplayPage (page)
 firstLine = page * yRes
 !mov ax, &h4F07
 !mov bx, 0
 !mov cx, 0
 !mov dx, firstLine
 !int &h10
END SUB





defint a-z
SUB DMCloseVESAMode ()
 !mov ax, &h3
 !int &h10
 screen 0
END SUB





defint a-z
SUB DMWaitForVtrace ()
 'this gives smoother animation, but slows it down a little
 wait &h3DA, 8
END SUB





defint a-z
SUB DM8NewPixmap (handle???, wide??, high??)
 handle??? = 0
 'the max width for a pixmap is 8191, since we're being 100% BASIC standard
 'compatible, so we have to check for this here...
 if wide?? > 8191 then exit sub
 'this is the total amount of memory the new pixmap will occupy
 pixmapArea??? = (wide?? * high?? + 4)
 'this is the amount in kb that we'll request
 memRequest??? = pixmapArea??? / 1024 + 1
 'here we allocate a block filled with zeroes (black)
 XMAllocateFilled memRequest???, handle???, 0, xmsErr
 'here's where we fill in the dimensions of the pixmap...
 x$ = mkwrd$(wide?? * 8) + mkwrd$(high??)
 XMWrite handle???, 0, x$, 4, xmsErr
end sub





defint a-z
SUB DM8GetPixmapArea (handle???, wide??, high??)
 x$ = "    "
 XMRead handle???, 0, x$, 4, xmsErr
 wide?? = cvwrd(left$(x$, 2)) / 8
 high?? = cvwrd(right$(x$, 2))
end sub





defint a-z
sub DM8CopyPixmap (srcHandle???, destHandle???, srcRect as theRect, destPoint as thePoint)
 'add bounds checks, fix the uneven line thing
 dim dp as thePoint
 lineWidth = srcRect.brh - srcRect.tlh + 1
 IsEven lineWidth, d
 if d = 0 then exit sub
 DM8GetPixmapArea srcHandle???, srcWide??, srcHigh??
 DM8GetPixmapArea destHandle???, destWide??, destHigh??
 dp = destPoint
 xmsVar.size = lineWidth
 xmsVar.sourceHandle = srcHandle???
 xmsVar.destHandle = destHandle???
 xmsVarSeg?? = varseg(xmsVar)
 xmsVarPtr?? = varptr(xmsVar)
 srcOffset??? = srcRect.tlv * srcWide?? + srcRect.tlh + 4
 destOffset??? = destPoint.v * destWide?? + destPoint.h + 4
 lineCount = srcRect.tlv
 do until lineCount > srcRect.brv
  'start blitting, one scanline at a time...
  xmsVar.sourceOffset = srcOffset???
  xmsVar.destOffset = destOffset???
  !mov ds, xmsVarSeg??
  !mov si, xmsVarPtr??
  !mov ah, 11
  !call xmsDriverAddr???
  srcOffset??? = srcOffset??? + srcWide??
  destOffset??? = destOffset??? + destWide??
  incr lineCount
 loop
end sub





defint a-z
sub DM8CopyPixmapClear (srcHandle???, destHandle???, srcRect as theRect, destPoint as thePoint, clearColor)
 'add bounds checks, fix the uneven line thing
 lineWidth = srcRect.brh - srcRect.tlh + 1
 IsEven lineWidth, d
 if d = 0 then exit sub
 DM8GetPixmapArea srcHandle???, srcWide??, srcHigh??
 DM8GetPixmapArea destHandle???, destWide??, destHigh??
 dim dp as thePoint
 dp = destPoint
 srcOffset??? = srcRect.tlv * srcWide?? + srcRect.tlh + 4
 destOffset??? = destPoint.v * destWide?? + destPoint.h + 4
 lineCount = srcRect.tlv
 lineBuffer$ = string$(lineWidth * 2 + 2, 0)
 transferSize = lineWidth
 IsEven transferSize, d
 if d = 0 then transferSize = transferSize + 1
 xmsVar.size = transferSize
 xmsVarSeg?? = varseg(xmsVar)
 xmsVarPtr?? = varptr(xmsVar)
 lineBufferSeg?? = strseg(lineBuffer$)
 srcPtr?? = strptr(lineBuffer$)
 destPtr?? = strptr(lineBuffer$) + transferSize
 'ok, def seg is SLOW!!!! so we avoid it since speed is the focus
 if pbvDefSeg <> lineBufferSeg?? then def seg = lineBufferSeg??
 lineBufferSrcPtrPrecalc??? = lineBufferSeg?? * 65536 + srcPtr??
 lineBufferDestPtrPrecalc??? = lineBufferSeg?? * 65536 + destPtr??
 do until lineCount > srcRect.brv
  'load a line from the source pixmap into memory...
  xmsVar.sourceHandle = srcHandle???
  xmsVar.sourceOffset = srcOffset???
  xmsVar.destHandle = 0
  xmsVar.destOffset = strptr32(lineBuffer$)
  !mov ds, xmsVarSeg??
  !mov si, xmsVarPtr??
  !mov ah, 11
  !call xmsDriverAddr???
  'load a line from the destination pixmap into memory...
  xmsVar.sourceHandle = destHandle???
  xmsVar.sourceOffset = destOffset???
  xmsVar.destOffset = lineBufferSrcPtrPrecalc???
  xmsVar.destOffset = lineBufferDestPtrPrecalc???
  !mov ds, xmsVarSeg??
  !mov si, xmsVarPtr??
  !mov ah, 11
  !call xmsDriverAddr???
  for a = 0 to lineWidth
   pixel = peek (srcPtr?? + a)
   if pixel <> clearColor then
    poke (destPtr?? + a), pixel
   end if
  next
  'load the calculated line back into the destination pixmap...
  xmsVar.sourceHandle = 0
  xmsVar.sourceOffset = lineBufferDestPtrPrecalc???
  xmsVar.destHandle = destHandle???
  xmsVar.destOffset = destOffset???
  !mov ds, xmsVarSeg??
  !mov si, xmsVarPtr??
  !mov ah, 11
  !call xmsDriverAddr???
  srcOffset??? = srcOffset??? + srcWide??
  destOffset??? = destOffset??? + destWide??
  incr lineCount
 loop
end sub





defint a-z
SUB DM8BlitToVRAM640x480 (handle???)
 'NOTE: to achieve better blitting speeds, no error checking is performed in
 'this function. You must ensure that the handle is valid prior to calling it.
 xmsVar.size = 65536
 xmsVar.sourceHandle = handle???
 xmsVar.destHandle = 0
 xmsVar.destOffset = &hA0000000
 t?? = winGran * 0
 !mov ax, &h4F05
 !mov bx, 0
 !mov dx, t??
 !int &h10
 xmsVar.sourceOffset = 4
 xmsVarSeg?? = varseg(xmsVar)
 xmsVarPtr?? = varptr(xmsVar)
 !mov ds, xmsVarSeg??
 !mov si, xmsVarPtr??
 !mov ah, 11
 !call xmsDriverAddr???
 t?? = winGran * 1
 !mov ax, &h4F05
 !mov bx, 0
 !mov dx, t??
 !int &h10
 xmsVar.sourceOffset = 65540
 xmsVarSeg?? = varseg(xmsVar)
 xmsVarPtr?? = varptr(xmsVar)
 !mov ds, xmsVarSeg??
 !mov si, xmsVarPtr??
 !mov ah, 11
 !call xmsDriverAddr???
 t?? = winGran * 2
 !mov ax, &h4F05
 !mov bx, 0
 !mov dx, t??
 !int &h10
 xmsVar.sourceOffset = 131076
 xmsVarSeg?? = varseg(xmsVar)
 xmsVarPtr?? = varptr(xmsVar)
 !mov ds, xmsVarSeg??
 !mov si, xmsVarPtr??
 !mov ah, 11
 !call xmsDriverAddr???
 t?? = winGran * 3
 !mov ax, &h4F05
 !mov bx, 0
 !mov dx, t??
 !int &h10
 xmsVar.sourceOffset = 196612
 xmsVarSeg?? = varseg(xmsVar)
 xmsVarPtr?? = varptr(xmsVar)
 !mov ds, xmsVarSeg??
 !mov si, xmsVarPtr??
 !mov ah, 11
 !call xmsDriverAddr???
 t?? = winGran * 4
 !mov ax, &h4F05
 !mov bx, 0
 !mov dx, t??
 !int &h10
 xmsVar.size = 45056
 xmsVar.sourceOffset = 262148
 xmsVarSeg?? = varseg(xmsVar)
 xmsVarPtr?? = varptr(xmsVar)
 !mov ds, xmsVarSeg??
 !mov si, xmsVarPtr??
 !mov ah, 11
 !call xmsDriverAddr???
END SUB





defint a-z
SUB DM8BlitToVRAM800x600 (handle???)
 'NOTE: to achieve better blitting speeds, no error checking is performed in
 'this function. You must ensure that the handle is valid prior to calling it.
 xmsVar.size = 65536
 xmsVar.sourceHandle = handle???
 xmsVar.destHandle = 0
 xmsVar.destOffset = &hA0000000
 t?? = winGran * 0
 !mov ax, &h4F05
 !mov bx, 0
 !mov dx, t??
 !int &h10
 xmsVar.sourceOffset = 4
 xmsVarSeg?? = varseg(xmsVar)
 xmsVarPtr?? = varptr(xmsVar)
 !mov ds, xmsVarSeg??
 !mov si, xmsVarPtr??
 !mov ah, 11
 !call xmsDriverAddr???
 t?? = winGran * 1
 !mov ax, &h4F05
 !mov bx, 0
 !mov dx, t??
 !int &h10
 xmsVar.sourceOffset = 65540
 xmsVarSeg?? = varseg(xmsVar)
 xmsVarPtr?? = varptr(xmsVar)
 !mov ds, xmsVarSeg??
 !mov si, xmsVarPtr??
 !mov ah, 11
 !call xmsDriverAddr???
 t?? = winGran * 2
 !mov ax, &h4F05
 !mov bx, 0
 !mov dx, t??
 !int &h10
 xmsVar.sourceOffset = 131076
 xmsVarSeg?? = varseg(xmsVar)
 xmsVarPtr?? = varptr(xmsVar)
 !mov ds, xmsVarSeg??
 !mov si, xmsVarPtr??
 !mov ah, 11
 !call xmsDriverAddr???
 t?? = winGran * 3
 !mov ax, &h4F05
 !mov bx, 0
 !mov dx, t??
 !int &h10
 xmsVar.sourceOffset = 196612
 xmsVarSeg?? = varseg(xmsVar)
 xmsVarPtr?? = varptr(xmsVar)
 !mov ds, xmsVarSeg??
 !mov si, xmsVarPtr??
 !mov ah, 11
 !call xmsDriverAddr???
 t?? = winGran * 4
 !mov ax, &h4F05
 !mov bx, 0
 !mov dx, t??
 !int &h10
 xmsVar.sourceOffset = 262148
 xmsVarSeg?? = varseg(xmsVar)
 xmsVarPtr?? = varptr(xmsVar)
 !mov ds, xmsVarSeg??
 !mov si, xmsVarPtr??
 !mov ah, 11
 !call xmsDriverAddr???
 t?? = winGran * 5
 !mov ax, &h4F05
 !mov bx, 0
 !mov dx, t??
 !int &h10
 xmsVar.sourceOffset = 327684
 xmsVarSeg?? = varseg(xmsVar)
 xmsVarPtr?? = varptr(xmsVar)
 !mov ds, xmsVarSeg??
 !mov si, xmsVarPtr??
 !mov ah, 11
 !call xmsDriverAddr???
 t?? = winGran * 6
 !mov ax, &h4F05
 !mov bx, 0
 !mov dx, t??
 !int &h10
 xmsVar.sourceOffset = 393220
 xmsVarSeg?? = varseg(xmsVar)
 xmsVarPtr?? = varptr(xmsVar)
 !mov ds, xmsVarSeg??
 !mov si, xmsVarPtr??
 !mov ah, 11
 !call xmsDriverAddr???
 t?? = winGran * 7
 !mov ax, &h4F05
 !mov bx, 0
 !mov dx, t??
 !int &h10
 xmsVar.size = 21248
 xmsVar.sourceOffset = 458756
 xmsVarSeg?? = varseg(xmsVar)
 xmsVarPtr?? = varptr(xmsVar)
 !mov ds, xmsVarSeg??
 !mov si, xmsVarPtr??
 !mov ah, 11
 !call xmsDriverAddr???
END SUB





defint a-z
SUB DM8BlitToVRAM1024x768 (handle???)
 'NOTE: to achieve better blitting speeds, no error checking is performed in
 'this function. You must ensure that the handle is valid prior to calling it.
 xmsVar.size = 65536
 xmsVar.sourceHandle = handle???
 xmsVar.destHandle = 0
 xmsVar.destOffset = &hA0000000
 t?? = winGran * 0
 !mov ax, &h4F05
 !mov bx, 0
 !mov dx, t??
 !int &h10
 xmsVar.sourceOffset = 4
 xmsVarSeg?? = varseg(xmsVar)
 xmsVarPtr?? = varptr(xmsVar)
 !mov ds, xmsVarSeg??
 !mov si, xmsVarPtr??
 !mov ah, 11
 !call xmsDriverAddr???
 t?? = winGran * 1
 !mov ax, &h4F05
 !mov bx, 0
 !mov dx, t??
 !int &h10
 xmsVar.sourceOffset = 65540
 xmsVarSeg?? = varseg(xmsVar)
 xmsVarPtr?? = varptr(xmsVar)
 !mov ds, xmsVarSeg??
 !mov si, xmsVarPtr??
 !mov ah, 11
 !call xmsDriverAddr???
 t?? = winGran * 2
 !mov ax, &h4F05
 !mov bx, 0
 !mov dx, t??
 !int &h10
 xmsVar.sourceOffset = 131076
 xmsVarSeg?? = varseg(xmsVar)
 xmsVarPtr?? = varptr(xmsVar)
 !mov ds, xmsVarSeg??
 !mov si, xmsVarPtr??
 !mov ah, 11
 !call xmsDriverAddr???
 t?? = winGran * 3
 !mov ax, &h4F05
 !mov bx, 0
 !mov dx, t??
 !int &h10
 xmsVar.sourceOffset = 196612
 xmsVarSeg?? = varseg(xmsVar)
 xmsVarPtr?? = varptr(xmsVar)
 !mov ds, xmsVarSeg??
 !mov si, xmsVarPtr??
 !mov ah, 11
 !call xmsDriverAddr???
 t?? = winGran * 4
 !mov ax, &h4F05
 !mov bx, 0
 !mov dx, t??
 !int &h10
 xmsVar.sourceOffset = 262148
 xmsVarSeg?? = varseg(xmsVar)
 xmsVarPtr?? = varptr(xmsVar)
 !mov ds, xmsVarSeg??
 !mov si, xmsVarPtr??
 !mov ah, 11
 !call xmsDriverAddr???
 t?? = winGran * 5
 !mov ax, &h4F05
 !mov bx, 0
 !mov dx, t??
 !int &h10
 xmsVar.sourceOffset = 327684
 xmsVarSeg?? = varseg(xmsVar)
 xmsVarPtr?? = varptr(xmsVar)
 !mov ds, xmsVarSeg??
 !mov si, xmsVarPtr??
 !mov ah, 11
 !call xmsDriverAddr???
 t?? = winGran * 6
 !mov ax, &h4F05
 !mov bx, 0
 !mov dx, t??
 !int &h10
 xmsVar.sourceOffset = 393220
 xmsVarSeg?? = varseg(xmsVar)
 xmsVarPtr?? = varptr(xmsVar)
 !mov ds, xmsVarSeg??
 !mov si, xmsVarPtr??
 !mov ah, 11
 !call xmsDriverAddr???
 t?? = winGran * 7
 !mov ax, &h4F05
 !mov bx, 0
 !mov dx, t??
 !int &h10
 xmsVar.sourceOffset = 458756
 xmsVarSeg?? = varseg(xmsVar)
 xmsVarPtr?? = varptr(xmsVar)
 !mov ds, xmsVarSeg??
 !mov si, xmsVarPtr??
 !mov ah, 11
 !call xmsDriverAddr???
 t?? = winGran * 8
 !mov ax, &h4F05
 !mov bx, 0
 !mov dx, t??
 !int &h10
 xmsVar.sourceOffset = 524292
 xmsVarSeg?? = varseg(xmsVar)
 xmsVarPtr?? = varptr(xmsVar)
 !mov ds, xmsVarSeg??
 !mov si, xmsVarPtr??
 !mov ah, 11
 !call xmsDriverAddr???
 t?? = winGran * 9
 !mov ax, &h4F05
 !mov bx, 0
 !mov dx, t??
 !int &h10
 xmsVar.sourceOffset = 589828
 xmsVarSeg?? = varseg(xmsVar)
 xmsVarPtr?? = varptr(xmsVar)
 !mov ds, xmsVarSeg??
 !mov si, xmsVarPtr??
 !mov ah, 11
 !call xmsDriverAddr???
 t?? = winGran * 10
 !mov ax, &h4F05
 !mov bx, 0
 !mov dx, t??
 !int &h10
 xmsVar.sourceOffset = 655364
 xmsVarSeg?? = varseg(xmsVar)
 xmsVarPtr?? = varptr(xmsVar)
 !mov ds, xmsVarSeg??
 !mov si, xmsVarPtr??
 !mov ah, 11
 !call xmsDriverAddr???
 t?? = winGran * 11
 !mov ax, &h4F05
 !mov bx, 0
 !mov dx, t??
 !int &h10
 xmsVar.sourceOffset = 720900
 xmsVarSeg?? = varseg(xmsVar)
 xmsVarPtr?? = varptr(xmsVar)
 !mov ds, xmsVarSeg??
 !mov si, xmsVarPtr??
 !mov ah, 11
 !call xmsDriverAddr???
END SUB





defint a-z
SUB DM8SetPoint (handle???, h, v, clr)
 x$ = "  "
 DM8GetPixmapArea handle???, wide??, high??
 pixelOffset??? = v * wide?? + h + 4
 XMRead handle???, pixelOffset???, x$, 2, xmsErr
 x$ = chr$(clr) + right$(x$, 1)
 XMWrite handle???, pixelOffset???, x$, 2, xmsErr
END SUB





defint a-z
sub DM8GetPoint (handle???, h, v, clr)
 x$ = "  "
 DM8GetPixmapArea handle???, wide??, high??
 if h < 0 or h >= wide?? then clr = -1:exit sub
 if v < 0 or v >= high?? then clr = -1:exit sub
 pixelOffset??? = v * wide?? + h + 4
 XMRead handle???, pixelOffset???, x$, 2, xmsErr
 clr = asc(left$(x$, 1))
end sub





defint a-z
sub DM8ReplaceColor (handle???, rect as theRect, color1, color2)
 for v = rect.tlv to rect.brv
  for h = rect.tlh to rect.brh
   DM8GetPoint handle???, h, v, c
   if c = color1 then
    DM8SetPoint handle???, h, v, color2
   end if
  next
 next
end sub





defint a-z
SUB DM8DrawLine (handle???, x1, y1, x2, y2, clr)
 xLength = x2 - x1
 yLength = y2 - y1
 d1X = SGN(xLength)
 d1Y = SGN(yLength)
 d2X = SGN(xLength)
 d2Y = 0
 xLen = ABS(xLength)
 yLen = ABS(yLength)
 IF xLen <= yLen THEN
  d2X = 0
  d2Y = SGN(yLength)
  xLen = ABS(yLength)
  yLen = ABS(xLength)
 END IF
 s = xLen \ 2
 x = x1: y = y1
 FOR i = 0 TO xLen
  DM8SetPoint handle???, x, y, clr
  s = s + yLen
  IF s >= xLen THEN
   s = s - xLen
   x = x + d1X
   y = y + d1Y
  ELSE
   x = x + d2X
   y = y + d2Y
  END IF
 NEXT i
END SUB





defint a-z
SUB DM8DrawRect (handle???, x1, y1, x2, y2, clr, style)
 select case style
  case = 0	'outline
   DM8DrawLine handle???, x1, y1, x2, y1, clr
   DM8DrawLine handle???, x1, y2, x2, y2, clr
   DM8DrawLine handle???, x2, y1, x2, y2, clr
   DM8DrawLine handle???, x1, y1, x1, y2, clr
  case = 1	'filled
   for y = y1 to y2
    DM8DrawLine handle???, x1, y, x2, y, clr
   next
 end select
end sub





defint a-z
SUB DM8DrawCircle (handle???, cx, cy, r, clr)
 d = 3 - 2 * r
 x = 0
 y = r
 DO
  DM8SetPoint handle???, cx + x, cy + y, clr
  DM8SetPoint handle???, cx + x, cy - y, clr
  DM8SetPoint handle???, cx - x, cy + y, clr
  DM8SetPoint handle???, cx - x, cy - y, clr
  DM8SetPoint handle???, cx + y, cy + x, clr
  DM8SetPoint handle???, cx + y, cy - x, clr
  DM8SetPoint handle???, cx - y, cy + x, clr
  DM8SetPoint handle???, cx - y, cy - x, clr
  IF d < 0 THEN
   d = d + (4 * x) + 6
  ELSE
   d = d + 4 * (x - y) + 10
   y = y - 1
  END IF
  x = x + 1
 LOOP WHILE x <= y
END SUB





defint a-z
sub DM8FillArea (handle???, h, v, c)
 nv = c
 x = h
 y = v
 DM8GetPixmapArea handle???, maxx??, maxy??
 maxx = maxx??
 maxy = maxy??
 DM8GetPoint handle???, x, y, ov
 IF ov = nv OR ov = -1 THEN EXIT SUB
 bsize = 4 * maxx 'enough for screen 12 and 13
 DIM stack(bsize) AS pix2type, sp AS INTEGER 'a queue (FIFO), indexs sp top and sp2 bottom
 'save the start point as a seed to the bottom
 stack(sp).y = y + 1
 stack(sp).xl = x
 stack(sp).xr = x
 stack(sp).dy = 1
 sp = sp + 1
 'and save the point below it as a fake seed to the top (it's really a seed for the starting point's line)
 stack(sp).y = y
 stack(sp).xl = x
 stack(sp).xr = x
 stack(sp).dy = -1
 sp = sp + 1
 'while there are seeds in the stack
 DO WHILE sp2 <> sp
  'retrieve a seed (a previous filled line) and try to fill the above or bottom line
  dy = stack(sp2).dy
  y = stack(sp2).y
  x1 = stack(sp2).xl
  x2 = stack(sp2).xr
  sp2 = sp2 + 1
  IF sp2 > bsize THEN sp2 = 0
  'any points in the line in contact with at least a point of the seed must be filled
  'try points left of the left side of the seed
  x = x1
  DM8GetPoint handle???, x, y, xx
  WHILE x > -1 AND (xx = ov)
   x = x - 1
   DM8GetPoint handle???, x, y, xx
  WEND
  IF x >= x1 THEN GOTO skip
  l = x + 1
  'store this non-overlapping left part as a seed for the line left to the present seed
  IF l < x1 THEN
   stack(sp).y = y - dy
   stack(sp).xl = l
   stack(sp).xr = x1 - 1
   stack(sp).dy = -dy
   sp = sp + 1
   IF sp > bsize THEN sp = 0
  END IF
  x = x1 + 1
  'go to the part that's contiguous to the seed and to the one to the righ side
  DO
   DM8GetPoint handle???, x, y, xx
   WHILE x <= maxx AND xx = ov
    x = x + 1
    DM8GetPoint handle???, x, y, xx
   WEND
   'we have a left and a right point,draw a line and save it as a seed for a further line
   FOR i = l TO x - 1
    DM8SetPoint handle???, i, y, nv
   NEXT
   stack(sp).y = y + dy
   stack(sp).xl = l
   stack(sp).xr = x - 1
   stack(sp).dy = dy
   sp = sp + 1
   IF sp > bsize THEN sp = 0
   'continue to the right..
   'if this part is non overlapping with the seed to the right, save it as a seed for line right to present seed
   IF x > x2 + 1 THEN
    stack(sp).y = y - dy
    stack(sp).xl = x2 + 1
    stack(sp).xr = x - 1
    stack(sp).dy = -dy
    sp = sp + 1
    IF sp > bsize THEN sp = 0
   END IF
   'skip the nonfillable pixels facing the seed
   skip:
   x = x + 1
   DM8GetPoint handle???, x, y, xx
   WHILE (x <= x2) AND (xx <> ov)
    x = x + 1
    DM8GetPoint handle???, x, y, xx
   WEND
   l = x
   'end when leftmost pixel is no more facing the seed
  LOOP WHILE x <= x2
 LOOP
 ERASE stack
end sub





sub DM8GetIndex (colorIndex, r, g, b)
 OUT &H3C8, colorIndex
 dummy = INP(&H3C9)
 dummy = INP(&H3C9)
 dummy = INP(&H3C9)
 r = INP(&H3C9)
 g = INP(&H3C9)
 b = INP(&H3C9)
end sub





sub DM8SetIndex (colorIndex, r, g, b)
 OUT &H3C8, colorIndex
 OUT &H3C9, r
 OUT &H3C9, g
 OUT &H3C9, b
end sub





sub DM8GetPalette (handle???)
 for a = 0 to 255
  DM8GetIndex a, r, g, b
  a$ = a$ + chr$(r) + chr$(g) + chr$(b)
 next
 XMWrite handle???, 0, a$, 768, xmsErr
end sub





sub DM8SetPalette (handle???)
 a$ = string$(768, 0)
 XMRead handle???, 0, a$, 768, xmsErr
 for a = 0 to 255
  r = asc(mid$(a$, a * 3 + 1, 1))
  g = asc(mid$(a$, a * 3 + 2, 1))
  b = asc(mid$(a$, a * 3 + 3, 1))
  DM8SetIndex a, r, g, b
 next
end sub





defint a-z
sub DMInitROMFont (fontArray?())
'load the rom font into the FontArray...
 screen 0
 xes?? = 0
 xbx?? = 0
 !mov ah, &h35
 !mov al, &h43
 !int &h21
 !mov xes??, es
 !mov xbx??, bx
 def seg = xes??
 for a = 0 to 2047
  fontArray?(a) = peek (xbx?? + a)
 next
end sub





defint a-z
sub DMPrint (handle???, fa?(), th, tv, tx$, dc)
 DM8GetPixmapArea handle???, wide??, high??
 baseV = tv * 8
 lineBuffer$ = string$(wide??, 0)
 addr??? = 4 + baseV * wide??
 xmsVar.size = wide??
 xmsVar.sourceHandle = handle???
 xmsVar.sourceOffset = addr???
 xmsVar.destHandle = 0
 xmsVar.destOffset = strPtr32(lineBuffer$)
 xmsVarSeg?? = varseg(xmsVar)
 xmsVarPtr?? = varptr(xmsVar)
 !mov ds, xmsVarSeg??
 !mov si, xmsVarPtr??
 !mov ah, 11
 !call xmsDriverAddr???
 lineBufferPtr?? = strptr(lineBuffer$)
 for v = 0 to 7
  baseH = th * 8
  for x = 1 to len(tx$)
   a = asc(mid$(tx$, x, 1))
   b = fa?(a * 8 + v)
   for h = 0 to 7
   if (2 ^ (7 - h) and b) then
    poke (lineBufferPtr?? + baseH + h), dc
   end if
   next
  baseH = baseH + 8
  next
  'put that line back into the pixmap...
  xmsVar.sourceHandle = 0
  xmsVar.sourceOffset = strPtr32(lineBuffer$)
  xmsVar.destHandle = handle???
  xmsVar.destOffset = addr???
  !mov ds, xmsVarSeg??
  !mov si, xmsVarPtr??
  !mov ah, 11
  !call xmsDriverAddr???
  'and load up another line...
  addr??? = 4 + (baseV + v) * wide??
  xmsVar.sourceHandle = handle???
  xmsVar.sourceOffset = addr???
  xmsVar.destHandle = 0
  xmsVar.destOffset = strPtr32(lineBuffer$)
  !mov ds, xmsVarSeg??
  !mov si, xmsVarPtr??
  !mov ah, 11
  !call xmsDriverAddr???
 next
end sub





sub DM8LoadBMP (handle???, destH, destV, filePath$)
 DIM bmfh AS bitmapFileHeader, bmih AS bitmapInfoHeader
 ff = FREEFILE
 OPEN filePath$ FOR BINARY AS #ff
 GET #ff, , bmfh
 GET #ff, , bmih
 x$ = "    "
 FOR a = 0 TO 2 ^ bmih.biBitCount - 1
  GET #ff, , x$
  r = ASC(MID$(x$, 3, 1)) \ 4
  g = ASC(MID$(x$, 2, 1)) \ 4
  b = ASC(MID$(x$, 1, 1)) \ 4
  DM8SetIndex a, r, g, b
 NEXT
 a$ = STRING$(bmih.biWidth, 0)
 b$ = " "
 pv = destV + bmih.biHeight - 1
 DM8GetPixmapArea handle???, wide??, high??
 xmsVar.size = len(a$)
 xmsVar.sourceHandle = 0
 xmsVar.sourceOffset = strPtr32(a$)
 xmsVar.destHandle = handle???
 xmsVarSeg?? = varseg(xmsVar)
 xmsVarPtr?? = varptr(xmsVar)
 DO UNTIL EOF(ff)
  GET #ff, , a$
  pixelOffset??? = pv * wide?? + destH + 4
  scanLineBytesRead = scanLineBytesRead + LEN(a$)
  xmsVar.destOffset = pixelOffset???
  !mov ds, xmsVarSeg??
  !mov si, xmsVarPtr??
  !mov ah, 11
  !call xmsDriverAddr???
  DO WHILE scanLineBytesRead / 4 <> INT(scanLineBytesRead / 4)
   scanLineBytesRead = scanLineBytesRead + 1
   GET #ff, , b$
  LOOP
  pv = pv - 1
  scanLineBytesRead = 0
  if pv < destV then exit do
 LOOP
 CLOSE #ff
end sub





sub DM8LoadGIF (handle???, h, v, filePath$)
 'Prefix() and Suffix() hold the LZW phrase dictionary.
 'OutStack() is used as a decoding stack.
 DIM Prefix(4095), Suffix(4095), OutStack(4095)
 fileNum = freefile
 OPEN filePath$ FOR BINARY AS fileNum
 'Check to see if GIF file. Ignore GIF version number.
 a$ = "      ": GET #fileNum, , a$
 IF LEFT$(a$, 3) <> "GIF" THEN
  'not a GIF file
  exit sub
 end if
 'Get logical screen's X and Y resolution.
 GET #fileNum, , TotalX: GET #fileNum, , totalY: GOSUB GetByte
 'Calculate number of colors and find out if a global palette exists.
 NumColors = 2 ^ ((a AND 7) + 1): NoPalette = (a AND 128) = 0
 'Retrieve background color.
 GOSUB GetByte: Background = a
 'Get aspect ratio and ignore it.
 GOSUB GetByte
 'Retrieve global palette if it exists.
 IF NoPalette = 0 THEN p$ = SPACE$(NumColors * 3): GET #fileNum, , p$
 DO 'Image decode loop
  'Skip by any GIF extensions.
  '(With a few modifications this code could also fetch comments.)
  DO
   'Skip by any zeros at end of image (why must I do this? the
   'GIF spec never mentioned it)
   DO
    IF EOF(fileNum) THEN exit sub	'if at end of file, exit
    GOSUB GetByte
   LOOP WHILE a = 0           'loop while byte fetched is zero
   SELECT CASE a
    CASE 44  'We've found an image descriptor!
     EXIT DO
    CASE 59  'GIF trailer, stop decoding.
     exit sub
    CASE IS <> 33
     'unknown GIF extension type
     exit sub
   END SELECT
   'Skip by blocked extension data.
   GOSUB GetByte
   DO: GOSUB GetByte: a$ = SPACE$(a): GET #fileNum, , a$: LOOP UNTIL a = 0
  LOOP
  'Get image's start coordinates and size.
  GET #fileNum, , XStart: GET #fileNum, , YStart: GET #fileNum, , XLength: GET #fileNum, , YLength
  XEnd = XStart + XLength: YEnd = YStart + YLength
  'Check for local colormap, and fetch it if it exists.
  GOSUB GetByte
  IF (a AND 128) THEN
   NoPalette = 0
   NumColors = 2 ^ ((a AND 7) + 1)
   p$ = SPACE$(NumColors * 3): GET #fileNum, , p$
  END IF
  'Check for interlaced image.
  Interlaced = (a AND 64) > 0: PassNumber = 0: PassStep = 8
  'Get LZW starting code size.
  GOSUB GetByte
  'Calculate clear code, end of stream code, and first free LZW code.
  ClearCode = 2 ^ a
  EOSCode = ClearCode + 1
  FirstCode = ClearCode + 2: NextCode = FirstCode
  StartCodeSize = a + 1: CodeSize = StartCodeSize
  'Find maximum code for the current code size.
  StartMaxCode = 2 ^ (a + 1) - 1: MaxCode = StartMaxCode
  BitsIn = 0: BlockSize = 0: BlockPointer = 1
  X = XStart: y = YStart
  'Set palette, if there was one.
  IF NoPalette = 0 THEN
   'Use OUTs for speed.
   OUT &H3C8, 0
   FOR a = 1 TO NumColors * 3: OUT &H3C9, ASC(MID$(P$, a, 1)) \ 4: NEXT
  END IF
  'Decode LZW data stream to screen.
  DO
   'Retrieve one LZW code.
   GOSUB GetCode
   'Is it an end of stream code?
   IF Code <> EOSCode THEN
    'Is it a clear code? (The clear code resets the sliding
    'dictionary - it *should* be the first LZW code present in
    'the data stream.)
    IF Code = ClearCode THEN
     NextCode = FirstCode
     CodeSize = StartCodeSize
     MaxCode = StartMaxCode
     DO: GOSUB GetCode: LOOP WHILE Code = ClearCode
     IF Code = EOSCode THEN exit do
     LastCode = Code: LastPixel = Code
     DM8SetPoint handle???, x, y, LastPixel
     X = X + 1: IF X = XEnd THEN GOSUB NextScanLine
    ELSE
     CurCode = Code: StackPointer = 0
     'Have we entered this code into the dictionary yet?
     IF Code >= NextCode THEN
      IF Code > NextCode THEN exit sub	'Bad GIF if this happens.
      'mimic last code if we haven't entered the requested code into the
      'dictionary yet
      CurCode = LastCode
      OutStack(StackPointer) = LastPixel
      StackPointer = StackPointer + 1
     END IF
     'Recursively get each character of the string. Since we get the
     'characters in reverse, "push" them onto a stack so we can "pop" them
     'off later. Hint: There is another, much faster way to accomplish
     'this that doesn't involve a decoding stack at all...
     DO WHILE CurCode >= FirstCode
      OutStack(StackPointer) = Suffix(CurCode)
      StackPointer = StackPointer + 1
      CurCode = Prefix(CurCode)
     LOOP
     LastPixel = CurCode
     DM8SetPoint handle???, x, y, LastPixel
     X = X + 1: IF X = XEnd THEN GOSUB NextScanLine
     '"Pop" each character onto the display.
     FOR a = StackPointer - 1 TO 0 STEP -1
      DM8SetPoint handle???, x, y, OutStack(a)
      X = X + 1: IF X = XEnd THEN GOSUB NextScanLine
     NEXT
     'Can we put this new string into our dictionary? (Some GIF encoders will
     'wait a bit when the dictionary is full before sending a clear code.
     'This increases compression because the dictionary's contents are thrown
     'away less often.)
     IF NextCode < 4096 THEN
      'Store new string in the dictionary for later use.
      Prefix(NextCode) = LastCode
      Suffix(NextCode) = LastPixel
      NextCode = NextCode + 1
      'Time to increase the LZW code size?
      IF (NextCode > MaxCode) AND (CodeSize < 12) THEN
       CodeSize = CodeSize + 1
       MaxCode = MaxCode * 2 + 1
      END IF
     END IF
     LastCode = Code
    END IF
   END IF
  LOOP UNTIL Code = EOSCode
 LOOP
 exit sub
 'Slowly reads one byte from the GIF file...
 GetByte:
  a$ = " ": GET #fileNum, , a$: a = ASC(a$)
 RETURN
 'Moves down one scanline. If the GIF is interlaced, then the number
 'of scanlines skipped is based on the current pass.
 NextScanLine:
  IF Interlaced THEN
   y = y + PassStep
   IF y >= YEnd THEN
    PassNumber = PassNumber + 1
    SELECT CASE PassNumber
     CASE 1: y = 4: PassStep = 8
     CASE 2: y = 2: PassStep = 4
     CASE 3: y = 1: PassStep = 2
    END SELECT
   END IF
  ELSE
   y = y + 1
  END IF
  X = XStart
 RETURN
 'Reads a multibit code from the data stream.
 GetCode:
  WorkCode??? = LastChar \ 2 ^ (8 - BitsIn)
  'Loop while more bits are needed.
  DO WHILE CodeSize > BitsIn
   'Reads a byte from the LZW data stream. Since the data stream is blocked,
   'a check is performed for the end of the current block before each byte is
   'fetched.
   IF BlockPointer > BlockSize THEN
    'Retrieve block's length
    GOSUB GetByte: BlockSize = a
    a$ = SPACE$(BlockSize): GET #fileNum, , a$
    BlockPointer = 1
   END IF
   'Yuck, ASC() and MID$() aren't that fast.
   LastChar = ASC(MID$(a$, BlockPointer, 1))
   BlockPointer = BlockPointer + 1
   'Append 8 more bits to the input buffer
   WorkCode??? = WorkCode??? OR LastChar * 2 ^ BitsIn
   BitsIn = BitsIn + 8
  LOOP
  'Take away x number of bits.
  BitsIn = BitsIn - CodeSize
  'Return code to caller.
  Code = WorkCode??? AND MaxCode
 RETURN
end sub





sub DM8LoadPCX (handle???, initialH, initialV, filePath$)
 dim header as pcxHeader
 fileNum = freefile
 OPEN filePath$ FOR BINARY AS fileNum
 get fileNum,, header
 xsize = header.xmax - header.xmin + 1
 IsEven xsize, d
 IF d = 0 THEN xsize = xsize + 1
 ysize = header.ymax - header.ymin + 1
 IsEven ysize, d
 IF d = 0 THEN ysize = ysize + 1
 imageBytes& = CLNG(header.planes) * CLNG(header.bytesPerLine)
 imageBytes& = CLNG(xsize) * CLNG(ysize)
 l& = LOF(fileNum)
 cpp& = l& - 768
 a$ = " "
 GET fileNum, cpp&, a$
 IF a$ = CHR$(12) THEN
  '256 colors
  cpp$ = STRING$(768, 0)
  GET fileNum, , cpp$
  cc = 0
  FOR a = 1 TO 768 STEP 3
   r = ASC(MID$(cpp$, a, 1)) \ 4
   g = ASC(MID$(cpp$, a + 1, 1)) \ 4
   b = ASC(MID$(cpp$, a + 2, 1)) \ 4
   DM8SetIndex cc, r, g, b
   cc = cc + 1
  NEXT
 ELSE
  IF header.colormap <> STRING$(48, 0) THEN
   '16 color images not supported
   close fileNum
   exit sub
  ELSE
   'no colormap found
  END IF
 END IF
 SEEK fileNum, 129
 z& = CLNG(xsize) * CLNG(ysize)
 v = 0
 h = 0
 FOR a& = 1 TO z&
  GET fileNum, , a$
  ascVal = ASC(a$)
  IF ascVal >= 192 THEN
   count = ascVal AND 63
   GET fileNum, , a$
   FOR aa = 1 TO count
    DM8SetPoint handle???, initialH + h, initialV+ v, asc(a$)
    totalBytes& = totalBytes& + 1
    h = h + 1
    IF h = xsize THEN h = 0: v = v + 1
    IF v > header.ymax THEN exit for
   NEXT
  ELSE
   DM8SetPoint handle???, initialH + h, initialV + v, ascVal
   totalBytes& = totalBytes& + 1
   h = h + 1
   IF h = xsize THEN h = 0: v = v + 1
   IF v > header.ymax THEN exit for
  END IF
  if totalBytes& > imageBytes& then exit for
 NEXT
 close fileNum
end sub





sub DM8SaveBMP (handle???, rect as theRect, filePath$)
 wide& = rect.brh - rect.tlh + 1
 high& = rect.brv - rect.tlv + 1
 DIM bmfh AS bitmapFileHeader, bmih AS bitmapInfoHeader
 ff = FREEFILE
 OPEN filePath$ FOR BINARY AS #ff
 'we put this in the file now as a placeholder, even though it's empty
 PUT #ff, , bmfh
 bmih.biSize = 40
 bmih.biWidth = wide&
 bmih.biHeight = high&
 bmih.biPlanes = 1
 bmih.biBitCount = 8
 bmih.biCompression = 0
 bmih.biSizeImage = wide& * high&
 bmih.biXPelsPerMeter = wide&
 bmih.biYPelsPerMeter = high&
 bmih.biClrUsed = 0
 bmih.biClrImportant = 0
 PUT #ff, , bmih
 FOR a = 0 TO 255
  DM8GetIndex a, r, g, b
  x$ = CHR$(b * 4) + CHR$(g * 4) + CHR$(r * 4) + CHR$(0)
  PUT #ff, , x$
 NEXT
 offsetBits = LOC(ff) - 1
 b$ = " "
 cv = rect.brv
 ch = rect.tlh
 DM8GetPixmapArea handle???, pixmapWide??, pixmapHigh??
 pixelBuffer$ = STRING$(bmih.biWidth, 0)
 DO
  IsEven len(pixelBuffer$), d
  if d = 0 then pixelBuffer$ = pixelBuffer$ + chr$(0):flag = 1
  xmsVar.size = len(pixelBuffer$)
  xmsVar.sourceHandle = handle???
  xmsVar.sourceOffset = cv * pixmapWide?? + ch + 4
  xmsVar.destHandle = 0
  xmsVar.destOffset = strptr32(pixelBuffer$)
  xmsVarSeg?? = varseg(xmsVar)
  xmsVarPtr?? = varptr(xmsVar)
  !mov ds, xmsVarSeg??
  !mov si, xmsVarPtr??
  !mov ah, 11
  !call xmsDriverAddr???
  if flag = 1 then pixelBuffer$ = left$(pixelBuffer$, len(pixelBuffer$) - 1)
  flag = 0
  scanLineBytesRead = LEN(pixelBuffer$)
  PUT #ff, , pixelBuffer$
  DO WHILE scanLineBytesRead / 4 <> INT(scanLineBytesRead / 4)
   scanLineBytesRead = scanLineBytesRead + 1
   PUT #ff, , b$
  LOOP
  ch = rect.tlh
  cv = cv - 1
  IF cv < 0 THEN EXIT DO
  scanLineBytesRead = 0
 LOOP
 bmfh.bfType = "BM"
 bmfh.bfSize = LOF(ff)
 bmfh.bfReserved1 = 0
 bmfh.bfReserved2 = 0
 bmfh.bfOffBits = offsetBits
 'now that this has data, we can put it in the file at the beginning
 SEEK #ff, 1
 PUT #ff, , bmfh
 CLOSE #ff
end sub





defint a-z
SUB DM8SaveGIF (handle???, rect as theRect, filePath$)
 DM8GetPixmapArea handle???, wide??, high??
 Xstart = rect.tlh
 YStart = rect.tlv
 Xend = rect.brh
 Yend = rect.brv
 screenX = XEnd - XStart + 1
 screenY = YEnd - YStart + 1
 'hash table's size - must be a prime number!
 TableSize = 7177
 numColors = 256
 DIM prefix(TableSize - 1), Suffix(TableSize - 1), code(TableSize - 1)
 'The shift table contains the powers of 2 needed by the
 'PutCode routine. This is done for speed. (much faster to
 'look up an integer than to perform calculations...)
 DIM shiftTable(7) AS LONG
 shiftTable(0) = 1
 shiftTable(1) = 2
 shiftTable(2) = 4
 shiftTable(3) = 8
 shiftTable(4) = 16
 shiftTable(5) = 32
 shiftTable(6) = 64
 shiftTable(7) = 128
 'MinX, MinY, MaxX, MaxY have the encoding window
 MinX = Xstart
 MinY = YStart
 MaxX = Xend
 MaxY = Yend
 'Open GIF output file
 fileNum = FREEFILE 'use next free file
 OPEN filePath$ FOR BINARY AS fileNum
 'Put GIF87a header at beginning of file
 b$ = "GIF87a"
 PUT fileNum, , b$
 'set data for how many colors are in this image...
 BitsPixel = 8 '8 bits per pixel
 StartSize = 9 'first LZW code is 9 bits
 StartCode = 256 'first free code
 StartMax = 512 'maximum code in 9 bits
 PUT fileNum, , ScreenX 'put screen's dimensions
 PUT fileNum, , ScreenY
 'pack colorbits and bits per pixel
 a = 208 + (BitsPixel - 1)
 PUT fileNum, , a
 'throw a zero into the GIF file
 a$ = CHR$(0)
 PUT fileNum, , a$
 'Get the RGB palette from the screen and put it into the file...
 OUT &H3C7, 0
 FOR a = 0 TO NumColors - 1
  r = (INP(&H3C9) * 65280) \ 16128
  g = (INP(&H3C9) * 65280) \ 16128
  b = (INP(&H3C9) * 65280) \ 16128
  colorRamp$ = colorRamp$ + CHR$(r) + CHR$(g) + CHR$(b)
 NEXT
 PUT fileNum, , colorRamp$
 'write out an image descriptor...
 a$ = "," '"," is image seperator
 PUT fileNum, , a$ 'write it
 'write out the image's location (always zero for our purposes)
 mm = 0
 PUT fileNum, , mm
 PUT fileNum, , mm
 ImageWidth = (MaxX - Minx + 1) 'find length & width of image
 ImageHeight = (MaxY - MinY + 1)
 PUT fileNum, , ImageWidth 'store them into the file
 PUT fileNum, , ImageHeight
 a$ = CHR$(BitsPixel - 1) '# bits per pixel in the image
 PUT fileNum, , a$
 a$ = CHR$(StartSize - 1) 'store the LZW minimum code size
 PUT fileNum, , a$
 'Initialize the vars needed by PutCode
 CurrentBit = 0: Char& = 0
 MaxCode = StartMax 'the current maximum code size
 CodeSize = StartSize 'the current code size
 ClearCode = StartCode 'ClearCode & EOF code are the
 EOFCode = StartCode + 1 ' first two entries
 StartCode = StartCode + 2 'first free code that can be used
 NextCode = StartCode 'the current code
 OutBuffer$ = STRING$(8192, 0) '8K output buffer; for speedier disk writes
 oSeg = strseg(outBuffer$)
 oAddress = strptr(outBuffer$)
 OEndAddress = OAddress + 8192 'end of disk buffer
 OStartAddress = OAddress 'current location in disk buffer
 DEF SEG = oSeg
 GOSUB ClearTree 'clear the tree & output a clear code
 PutCodeVar = ClearCode
 GOSUB PutCode
 'x & y have the current pixel
 x = Xstart
 y = YStart
 'pixelBuffer is used to rapidly read in the image data...
 pixelBuffer$ = string$(wide??, 0)
 IsEven len(pixelBuffer$), d
 if d = 0 then pixelBuffer$ = pixelBuffer$ + chr$(0)
 xmsVar.size = len(pixelBuffer$)
 xmsVar.sourceHandle = handle???
 xmsVar.sourceOffset = y * wide?? + 4
 xmsVar.destHandle = 0
 xmsVar.destOffset = strptr32(pixelBuffer$)
 xmsVarSeg?? = varseg(xmsVar)
 xmsVarPtr?? = varptr(xmsVar)
 !mov ds, xmsVarSeg??
 !mov si, xmsVarPtr??
 !mov ah, 11
 !call xmsDriverAddr???
 pixelBufferSeg?? = strseg(pixelBuffer$)
 pixelBufferPtr?? = strptr(pixelBuffer$)
 def seg = pixelBufferSeg??
 'the first pixel is a special case
 prefix = peek (pixelBufferPtr?? + x)
 x = x + 1
 IF x > MaxX THEN
  x = Minx
  y = y + 1
  IF y > MaxY THEN
   Done = 1
  else
   'load up the next scanline...
   xmsVar.sourceOffset = y * wide?? + 4
   !mov ds, xmsVarSeg??
   !mov si, xmsVarPtr??
   !mov ah, 11
   !call xmsDriverAddr???
  END IF
 END IF
 Done = 0 'True when image is complete
 DO 'while there are more pixels to encode
  DO 'until we have a new string to put into the table
   IF Done THEN 'write out the last pixel, clear the disk buffer
    'and fix up the last block so its count is correct
    PutCodeVar = prefix
    GOSUB PutCode 'write last pixel
    PutCodeVar = EOFCode
    GOSUB PutCode 'send EOF code
    IF CurrentBit <> 0 THEN
     PutCodeVar = 0
     GOSUB PutCode 'flush out the last code...
    END IF
    PutByteVar = 0
    GOSUB PutByte
    OutBuffer$ = LEFT$(OutBuffer$, OAddress - OStartAddress)
    PUT fileNum, , OutBuffer$
    a$ = ";" + STRING$(8, &H1A) 'the 8 EOF chars is not standard,
    'but many GIF's have them, so how much could it hurt?
    PUT fileNum, , a$
    a$ = CHR$(255 - BlockLength) 'correct the last block's count
    PUT fileNum, LastLoc&, a$
    CLOSE fileNum
    EXIT SUB
   ELSE 'get a pixel from the screen and see if we can find
    'the new string in the table
    suffix = peek (pixelBufferPtr?? + x)
    x = x + 1
    IF x > MaxX THEN
     x = Minx
     y = y + 1
     IF y > MaxY THEN
      Done = 1
     else
      'load up the next scanline...
      xmsVar.sourceOffset = y * wide?? + 4
      !mov ds, xmsVarSeg??
      !mov si, xmsVarPtr??
      !mov ah, 11
      !call xmsDriverAddr???
     END IF
    END IF
    GOSUB Hash 'is it there?
    IF Found = 1 THEN
     'yup, replace the prefix:suffix string with whatever code represents
     'it in the table
     prefix = code(index&)
    END IF
   END IF
  LOOP WHILE Found 'don't stop unless we find a new string
  PutCodeVar = prefix
  GOSUB PutCode 'output the prefix to the file
  prefix(index&) = prefix 'put the new string in the table
  Suffix(index&) = Suffix
  code(index&) = NextCode 'we've got to keep track if what code this is!
  prefix = Suffix 'Prefix=the last pixel pulled from the screen
  NextCode = NextCode + 1 'get ready for the next code
  IF NextCode = MaxCode + 1 THEN 'can an output code ever exceed
   'the current code size?
   'yup, increase the code size
   MaxCode = MaxCode * 2
   IF CodeSize = 12 THEN 'is the code size too big?
    PutCodeVar = ClearCode
    GOSUB PutCode 'yup; clear the table and start over
    GOSUB ClearTree
    NextCode = StartCode
    CodeSize = StartSize
    MaxCode = StartMax
   ELSE
    CodeSize = CodeSize + 1 'just increase the code size if
   END IF 'it's not too high( not > 12)
  END IF
 LOOP 'while we have more pixels
 ClearTree:
  FOR a = 0 TO TableSize - 1 'clears the hashing table
   prefix(a) = -1 '-1 = invalid entry
   Suffix(a) = -1
   code(a) = -1
  NEXT
  RETURN
 Hash:
  'hash the prefix & suffix(there are also many ways to do this...)
  index& = ((prefix * 256&) XOR Suffix) MOD TableSize
  'Note: the table size (7177 in this case) must be a prime number, or
  'else there's a chance that the routine will hang up
  'Calculate an offset just in case we don't find what we want on the
  'first try...
  IF index& = 0 THEN 'can't have TableSize-0 !
   Offset = 1
  ELSE
   Offset = TableSize - index&
  END IF
  DO 'until we (1) find an empty entry or (2) find what we're looking for
   IF code(index&) = -1 THEN 'is this entry blank?
    Found = 0 'yup- we didn't find the string
    RETURN
    'is this entry the one we're looking for?
   ELSEIF prefix(index&) = prefix AND Suffix(index&) = Suffix THEN
    'yup, congrats you now understand hashing!!!
    Found = 1
    RETURN
   ELSE
    'shoot! we didn't find anything interesting, so we must
    'retry- this is what slows hashing down. I could've used
    'a bigger table, that would of speeded things up a little
    'because this retrying would not happen as often...
    index& = index& - Offset
    IF index& < 0 THEN index& = index& + TableSize
   END IF
  LOOP
 PutCode:
  Char& = Char& + PutCodeVar * shiftTable(CurrentBit) 'put the char were it belongs
  CurrentBit = CurrentBit + CodeSize ' shifting it to its proper place
  DO WHILE CurrentBit > 7 'do we have a least one full byte?
   PutByteVar = Char& AND 255
   GOSUB PutByte ' yup! mask it off and write it out
   Char& = Char& \ 256 'shift the bit buffer right 8 bits
   CurrentBit = CurrentBit - 8 'now we have 8 less bits
  LOOP 'until we don't have a full byte
 RETURN
 PutByte:
  BlockLength = BlockLength - 1 'are we at the end of a block?
  IF BlockLength <= 0 THEN ' yup,
   BlockLength = 255 'block length is now 255
   LastLoc& = LOC(1) + (OAddress - OStartAddress) 'remember the pos for later fixing
   BufferWriteVar = 255
   GOSUB BufferWrite
  END IF
  BufferWriteVar = PutByteVar
  GOSUB BufferWrite  'put a byte into the buffer
 RETURN
 BufferWrite:
  IF OAddress = OEndAddress THEN 'are we at the end of the buffer?
  PUT fileNum, , OutBuffer$ ' yup, write it out and
  OAddress = OStartAddress ' start all over
  END IF
  POKE OAddress, BufferWriteVar 'put byte in buffer
  OAddress = OAddress + 1 'increment position
 RETURN
END SUB





sub DM8SavePCX (handle???, rect as theRect, filePath$)
 DM8GetPixmapArea handle???, pixmapWide??, pixmapHigh??
 wide = rect.brh - rect.tlh + 1
 high = rect.brv - rect.tlv + 1
 bytesPerLine = wide
 IsEven bytesPerLine, d
 IF d = 0 THEN bytesPerLine = bytesPerLine + 1
 DIM header AS pcxHeader
 header.manufacturer = 10
 header.version = 5
 header.encoding = 1
 header.bitsPerPixel = 8
 header.xmin = 0
 header.ymin = 0
 header.xmax = wide - 1
 header.ymax = high - 1
 header.hres = wide
 header.vres = high
 header.colormap = STRING$(48, 13)
 header.reserved1 = 0
 header.planes = 1
 header.bytesPerLine = bytesPerLine
 header.paletteInfo = 1
 header.filler = ""
 ff = FREEFILE
 OPEN filePath$ FOR BINARY AS #ff
 PUT #ff, , header
 xsize = wide: IsEven xsize, d: IF d = 0 THEN xsize = xsize + 1
 ysize = high: IsEven ysize, d: IF d = 0 THEN ysize = ysize + 1
 imageBytes& = CLNG(header.planes) * CLNG(header.bytesPerLine)
 imageBytes& = CLNG(xsize) * CLNG(ysize)
 v = rect.tlv
 h = rect.tlh
 'pixelBuffer is used to rapidly read in the image data...
 pixelBuffer$ = string$(pixmapWide??, 0)
 IsEven len(pixelBuffer$), d
 if d = 0 then pixelBuffer$ = pixelBuffer$ + chr$(0)
 xmsVar.size = len(pixelBuffer$)
 xmsVar.sourceHandle = handle???
 xmsVar.sourceOffset = v * pixmapWide?? + 4
 xmsVar.destHandle = 0
 xmsVar.destOffset = strptr32(pixelBuffer$)
 xmsVarSeg?? = varseg(xmsVar)
 xmsVarPtr?? = varptr(xmsVar)
 !mov ds, xmsVarSeg??
 !mov si, xmsVarPtr??
 !mov ah, 11
 !call xmsDriverAddr???
 pixelBufferSeg?? = strseg(pixelBuffer$)
 pixelBufferPtr?? = strptr(pixelBuffer$)
 def seg = pixelBufferSeg??
 DO
  c = peek (pixelBufferPtr?? + h)
  count = 1
  FOR aa = 1 TO 62
   IF h + 1 < wide THEN
    t = peek (pixelBufferPtr?? + h + 1)
    IF t <> c THEN
     EXIT FOR
    ELSE
     h = h + 1
     count = count + 1
    END IF
   ELSE
    EXIT FOR
   END IF
  NEXT
  IF count = 1 AND c < 192 THEN
   a$ = CHR$(c)
  ELSE
   a$ = CHR$(192 + count) + CHR$(c)
  END IF
  PUT #ff, , a$
  h = h + 1
  IF h > rect.brh THEN
   h = rect.tlh
   v = v + 1
   xmsVar.sourceOffset = v * pixmapWide?? + 4
   !mov ds, xmsVarSeg??
   !mov si, xmsVarPtr??
   !mov ah, 11
   !call xmsDriverAddr???
  end if
  IF v > rect.brv THEN EXIT DO
 LOOP
 x$ = CHR$(12)
 FOR a = 0 TO 255
  DM8GetIndex a, r, g, b
  x$ = x$ + CHR$(r * 4) + CHR$(g * 4) + CHR$(b * 4)
 NEXT
 PUT #ff, , x$
 CLOSE #ff
end sub





'--------------------
'XMS Manager routines
'--------------------





defint a-z
SUB XMInit (successFlag, xmsHandlesAvailable, handlesLimitedBy)
 successFlag = 0
 xmsHandlesAvailable = 0
 xmsDriverAddr??? = 0
 'check for XMS driver...
 xmsInst = 0
 !mov ax, &h4300
 !int &h2F
 !mov xmsInst, al
 if xmsInst <> &h80 then exit sub
 'get the address of the XMS driver
 !mov ax, &h4310
 !int &h2F
 !mov xmsDriverSeg??, es
 !mov xmsDriverPtr??, bx
 xmsDriverAddr??? = xmsDriverSeg?? * 65536 + xmsDriverPtr??
 successFlag = 1
 'here we check to see how many handles we have at our disposal
 dim xmsHandleTemp???(0 to 1023)
 for aa??? = 0 to 65535
  XMAllocate 1, handle???, xmsErr
  if xmsErr = &hA0 then handlesLimitedBy = 1:exit for
  if xmsErr = &hA1 then handlesLimitedBy = 2:exit for
  if xmsErr = 0 then incr xmsHandlesAvailable
  if counter <= ubound(xmsHandleTemp???) then
   xmsHandleTemp???(counter) = handle???
   counter = counter + 1
  end if
 next
 'NOW WE GIVE BACK ALL THE HANDLES AND ERASE THE ARRAY THAT HELD THEM...
 for aa = 0 to counter - 1
  XMRelease xmsHandleTemp???(aa), xmsErr
 next
 erase xmsHandleTemp???
END SUB





DEFINT A-Z
SUB XMMemoryAvailable (xmsFree???)
 xmsFree??? = 0
 listMax = 1023
 dim handles???(0 to listMax)
 gosub XMSAvailGetXMS
 do while xmsLFB?? <> 0
  xmsSize??? = xmsLFB??
  XMAllocate xmsSize???, handles???(counter), xmsErr
  if xmsErr = 0 then
   counter = counter + 1
   xmsFree??? = xmsFree??? + xmsLFB??
   gosub XMSAvailGetXMS
  else
   exit do
  end if
 loop
 for a = 0 to listMax
  if handles???(a) <> 0 then XMRelease handles???(a), xmsErr
 next
 erase handles???
 xmsErr = 0
 exit sub
 XMSAvailGetXMS:
  xax = 0
  xbl = 0
  xmsErr = 0
  xmsLFB?? = 0
  !mov ah, 8
  !call xmsDriverAddr???
  !mov xmsLFB??, ax
  !mov xax, ax
  !mov xbl, bl
  if xax = 0 then xmsErr = xbl
 return
END SUB





DEFINT A-Z
SUB XMAllocate (xmsSize???, handle???, xmsErr)
 xax = 0
 xbl = 0
 xmsErr = 0
 xmsRequest??? = xmsSize???
 xmsHandle??? = 0
 !mov ah, 9
 !mov dx, xmsRequest???
 !call xmsDriverAddr???
 !mov xax, ax
 !mov xbl, bl
 if xax = 0 then xmsErr = xbl
 !mov xmsHandle???, dx
 handle??? = xmsHandle???
END SUB





DEFINT A-Z
SUB XMAllocateFilled (xmsSize???, handle???, fillChar, xmsErr)
 xax = 0
 xbl = 0
 xmsErr = 0
 xmsRequest??? = xmsSize???
 xmsHandle??? = 0
 !mov ah, 9
 !mov dx, xmsRequest???
 !call xmsDriverAddr???
 !mov xax, ax
 !mov xbl, bl
 if xax = 0 then xmsErr = xbl
 !mov xmsHandle???, dx
 handle??? = xmsHandle???
 totalAmount??? = xmsSize??? * 1024
 if totalAmount??? < 32750 then
  a$ = string$(totalAmount???, fillChar)
 else
  a$ = string$(32750, fillChar)
 end if
 do until clearedAmount??? = totalAmount???
  XMWrite handle???, clearedAmount???, a$, len(a$), xmsErr
  clearedAmount??? = clearedAmount??? + len(a$)
  if totalAmount??? - clearedAmount??? < 32750 then
   a$ = string$(totalAmount??? - clearedAmount???, fillChar)
  end if
 loop
END SUB





DEFINT A-Z
SUB XMRelease (handle???, xmsErr)
 xax = 0
 xbl = 0
 xmsErr = 0
 xmsHandle??? = handle???
 !mov ah, 10
 !mov dx, xmsHandle???
 !call xmsDriverAddr???
 !mov xax, ax
 !mov xbl, bl
 if xax = 0 then xmsErr = xbl
END SUB





DEFINT A-Z
SUB XMBlockSize (handle???, size??, xmsErr)
 xax = 0
 xbl = 0
 xmsErr = 0
 xSize?? = 0
 xmsHandle?? = handle???
 !mov ah, &h0E
 !mov dx, xmsHandle??
 !call xmsDriverAddr???
 !mov xSize??, dx
 !mov xax, ax
 !mov xbl, bl
 if xax = 0 then xmsErr = xbl
 size?? = xSize??
END SUB





DEFINT A-Z
SUB XMChangeBlockSize (handle???, newSize??, xmsErr)
 xax = 0
 xbl = 0
 xmsErr = 0
 nSize?? = newSize??
 xmsHandle?? = handle???
 !mov ah, &h0F
 !mov bx, nSize??
 !mov dx, xmsHandle??
 !call xmsDriverAddr???
 !mov xax, ax
 !mov xbl, bl
 if xax = 0 then xmsErr = xbl
END SUB





DEFINT A-Z
SUB XMRead (handle???, addr???, xData$, length, xmsErr)
 xax = 0
 xbl = 0
 xmsErr = 0
 'not all xms drivers check to see if the tranfer length is even or odd, so
 'we have to enforce this rule on our own
 if length / 2 - int(length / 2) <> 0 then xmsErr = &hA7:exit sub
 xmsVar.size = length
 xmsVar.sourceHandle = handle???
 xmsVar.sourceOffset = addr???
 xmsVar.destHandle = 0
 xmsVar.destOffset = strPtr32(xData$)
 xmsVarSeg?? = varseg(xmsVar)
 xmsVarPtr?? = varptr(xmsVar)
 !mov ds, xmsVarSeg??
 !mov si, xmsVarPtr??
 !mov ah, 11
 !call xmsDriverAddr???
 !mov xax, ax
 !mov xbl, bl
 if xax = 0 then xmsErr = xbl
END SUB





DEFINT A-Z
SUB XMWrite (handle???, addr???, xData$, length, xmsErr)
 xax = 0
 xbl = 0
 xmsErr = 0
 'once again, we enforce the even length tranfer rule...
 if length / 2 - int(length / 2) <> 0 then xmsErr = &hA7:exit sub
 xmsVar.size = length
 xmsVar.sourceHandle = 0
 xmsVar.sourceOffset = strPtr32(xData$)
 xmsVar.destHandle = handle???
 xmsVar.destOffset = addr???
 xmsVarSeg?? = varseg(xmsVar)
 xmsVarPtr?? = varptr(xmsVar)
 !mov ds, xmsVarSeg??
 !mov si, xmsVarPtr??
 !mov ah, 11
 !call xmsDriverAddr???
 !mov xax, ax
 !mov xbl, bl
 if xax = 0 then xmsErr = xbl
END SUB










'misc
DEFINT A-Z
SUB IsEven (digit, d)
 a$ = LTRIM$(RTRIM$(STR$(digit)))
 b$ = RIGHT$(a$, 1)
 IF b$ = "2" OR b$ = "4" OR b$ = "6" OR b$ = "8" OR b$ = "0" THEN d = 1 ELSE d = 0
END SUB