'PCOS Kernel File Module (filemod.bas) version 2.0
'Copyright 1995-2008 by Mercury0x000D

'filemod.bas is a part of the PCOS Kernel

'The PCOS Kernel is free software: you can redistribute it and/or modify
'it under the terms of the GNU General Public License as published by
'the Free Software Foundation, either version 3 of the License, or
'(at your option) any later version.

'The PCOS Kernel is distributed in the hope that it will be useful,
'but WITHOUT ANY WARRANTY; without even the implied warranty of
'MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
'GNU General Public License for more details.

'You should have received a copy of the GNU General Public License
'along with the PCOS Kernel.  If not, see <http://www.gnu.org/licenses/>.

'See the included file <GPL License.txt> for the complete text of the 
'GPL License by which this program is covered.





defint a-z
$dynamic
option binary base 1

'file module globals
type fileDataType
 threadNum as dword		'number of the thread that opened the file
 filePath as string * 255	'filePath$ is always in the 8.3 format
 fileNum as integer
end type

dim fileRecord (0 to 7) as fileDataType
shared fileRecord()


'XMS Manager globals
type handleListType
 threadNum as dword		'number of the allocating thread
 handle as dword
 blockSize as dword
end type

type xmsVarType
 '16 bytes
 size as dword
 sourceHandle as word
 sourceOffset as dword
 destHandle as word
 destOffset as dword
end type
dim handleList (0 to 63) as handleListType
shared handleList()
dim xmsVar as xmsVarType
shared xmsDriverAddr???, xmsVar, xmsDriverSeg??, xmsDriverPtr??









'demo code starts here...

fmcreatefile "special system data.txt", 0
FMOpen 147, "special system data.txt", filenum


a$ = "01234567890123456789012345678901234567" + chr$(13) + chr$(10)
for a = 1 to 1024
 put #filenum,, a$
next

XMInit successFlag, xmsHandlesAvailable, handlesLimitedBy
XMAllocate 100, handle???, xmsErr

FMRead fileNum, 1, handle???, 0, 1024 * 40, xmsErr
?"file read done"

fmcreatefile "another sample filename.txt", 0
FMOpen 147, "another sample filename.txt", filenum2


theStr$ = "DOS rules - in all its forms" + chr$(13) + chr$(10)
TMInsertStr handle???, 41, theStr$


FMWrite fileNum2, 1, handle???, 0, 1024 * 40, xmsErr
?"file write done"

'a$ = string$(32000, 32)
'XMRead handle???, 0, a$, 32000, xmsErr
'for a =  1 to len(a$)
' b$ = mid$(a$,a,1)
' if b$ >= " " then ?b$;
'next

sleep
cls
system





defint a-z
SUB FMCreateFile(filePath$, attribs)
 fileName$ = filePath$ + chr$(0)
 xax?? = 0
 xcx?? = attribs
 pSeg?? = strseg(fileName$)
 pPtr?? = strptr(fileName$)
 !mov ax, &h716C
 !mov bx, 2
 !mov cx, xcx??
 !mov dx, 16
 !push ds
 !mov ds, pSeg??
 !mov si, pPtr??
 !int &h21
 !pop ds
 !mov xax??, ax
 'close the handle we just got, since there's no option (that I'm aware of)
 'to creat a file without also opening it...
 !mov ah, &h3E
 !mov bx, xax??
 !int &h21
END SUB





defint a-z
SUB FMCreateDir(filePath$)
 pathname$ = filePath$ + chr$(0)
 pSeg?? = strseg(pathname$)
 pPtr?? = strptr(pathname$)
 !mov ax, &h7139
 !push ds
 !mov ds, pSeg??
 !mov dx, pPtr??
 !int &h21
 !pop ds
END SUB





defint a-z
sub FMOpen (threadNum, filePath$, fileNum)
 FMLongToShort filePath$, p$
 'we only use freefile if a number wasn't already specified
 if fileNum = 0 then fileNum = freefile
 open p$ for binary as fileNum
 'we need to find a free slot in the file records list...
 freeSlot = -1
 for a = lbound(fileRecord) to ubound(fileRecord)
  if rtrim$(fileRecord(a).filePath$) = "" then
   freeSlot = a
   exit for
  end if
 next
 if freeSlot = -1 then
  'no free slot was found, so we have to increase the size of the record
  dim temp(lbound(fileRecord) to ubound(fileRecord)) as fileDataType
  for x = lbound(fileRecord) to ubound(fileRecord)
   temp(x) = fileRecord(x)
  next
  redim fileRecord(lbound(temp) to ubound(temp) + 1)
  for x = lbound(temp) to ubound(temp)
   fileRecord(x) = temp(x)
  next
  erase temp()
  freeSlot = ubound(fileRecord)
 end if
 fileRecord(freeSlot).threadNum = threadNum
 fileRecord(freeSlot).filePath$ = filePath$
 fileRecord(freeSlot).fileNum = fileNum
end sub





defint a-z
sub FMRead (fileNum, fileLoc???, handle???, addr???, length???, xmsErr)
 seek(fileNum), fileloc???
 if length??? <= 32000 then
  a$ = string$(length???, 0)
 else
  a$ = string$(32000, 0)
 end if
 processIncrement = len(a$)
 do until processedLength??? = length???
  get #fileNum,, a$
  XMWrite handle???, addr??? + processedLength???, a$, processIncrement, xmsErr
  processedLength??? = processedLength??? + processIncrement
  if processIncrement > length??? - processedLength??? then
   a$ = string$(length??? - processedLength???, 0)
   processIncrement = len(a$)
  end if
 loop
end sub





defint a-z
sub FMWrite (fileNum, fileLoc???, handle???, addr???, length???, xmsErr)
 seek(fileNum), fileloc???
 if length??? <= 32000 then
  a$ = string$(length???, 0)
 else
  a$ = string$(32000, 0)
 end if
 processIncrement = len(a$)
 do until processedLength??? = length???
  XMRead handle???, addr??? + processedLength???, a$, processIncrement, xmsErr
  put #fileNum,, a$
  processedLength??? = processedLength??? + processIncrement
  if processIncrement > length??? - processedLength??? then
   a$ = string$(length??? - processedLength???, 0)
   processIncrement = len(a$)
  end if
 loop
end sub





defint a-z
sub FMGetLoc (fileNum, currentLoc&)
 currentLoc& = seek(fileNum)
end sub





defint a-z
sub FMSetLoc (fileNum, newLoc&)
 seek(fileNum), newLoc&
end sub





defint a-z
sub FMClose (fileNum)
 close fileNum
 'now we have to take the entry outta the file record...
 for a = lbound(fileRecord) to ubound(fileRecord)
  if fileRecord(a).fileNum = fileNum then
   deleteSlot = a
   exit for
  end if
 next
 fileRecord(deleteSlot).threadNum = 0
 fileRecord(deleteSlot).filePath$ = ""
 fileRecord(deleteSlot).fileNum = 0
 if ubound(fileRecord) - lbound(fileRecord) > 7 then
  'here we shrink the list by one to save memory
  dim temp(lbound(fileRecord) to ubound(fileRecord) - 1) as fileDataType
  counter = lbound(temp)
  for x = lbound(fileRecord) to ubound(fileRecord)
   if x <> deleteSlot then
    temp(counter) = fileRecord(x)
    counter = counter + 1
   end if
  next
  redim fileRecord(lbound(temp) to ubound(temp))
  for x = lbound(temp) to ubound(temp)
   fileRecord(x) = temp(x)
  next
  erase temp()
 end if
end sub





defint a-z
sub FMCloseAll (threadNum???)
 for x = lbound(fileRecord) to ubound(fileRecord)
  if x >= lbound(fileRecord) and x <= ubound(fileRecord) then
   if fileRecord(x).threadNum = threadNum??? then
    FMClose fileRecord(x).fileNum
   end if
  end if
 next
end sub





defint a-z
sub FMRename (oldPath$, newPath$, fileErr)
 fileErr = 0
 oldf$ = oldPath$ + chr$(0)
 newf$ = newPath$ + chr$(0)
 oSeg?? = strseg(oldf$)
 oPtr?? = strptr(oldf$)
 nSeg?? = strseg(newf$)
 nPtr?? = strptr(newf$)
 xax?? = 0
 xFunc?? = &h7156
 FMRenameBegin:
 !mov ax, xFunc??
 !push ds
 !mov ds, oSeg??
 !mov dx, oPtr??
 !mov es, nSeg??
 !mov di, nPtr??
 !int &h21
 !pop ds
 !jc FMRenameError
 exit sub
 FMRenameError:
 !mov xax??, ax
 if xax?? = &h7100 then
  'this traps if the lfn version of this function isn't supported
  'if it isn't, we use the old style version
  xFunc?? = &h56
  goto FMRenameBegin
 end if
 if xax?? = 5 then
  'access denied: this means the file was open while we tried the rename
  FMLookupDataByPath threadNum, oldPath$, fileNum
  'we keep looping here till all references to this file have been updated
  do while fileNum <> 0
   'get the current position in the file
   seekTo& = seek(fileNum)
   'close it
   FMClose fileNum
   'now rename again
   !mov ax, xFunc??
   !push ds
   !mov ds, oSeg??
   !mov dx, oPtr??
   !mov es, nSeg??
   !mov di, nPtr??
   !int &h21
   !pop ds
   !jc FMRenameFileExists
   'open it again and reset the position
   FMOpen threadNum, newPath$, fileNum
   seek (fileNum), seekTo&
   'get data for the next pass through the loop...
   FMLookupDataByPath threadNum, oldPath$, fileNum
  loop
 end if
 exit sub
 FMRenameFileExists:
 'this traps if newPath$ already exists
 fileErr = 800 + xax??
 if xax?? = 5 then fileErr = 58
END SUB





defint a-z
sub FMDeleteFile (filePath$)
 if filePath$ = "" then exit sub
 'make sure the file's closed...
 fileNum = 99
 do until fileNum = 0
  FMLookupDataByPath threadNum, filePath$, fileNum
  FMClose fileNum
  ?fileNum
 loop
 'make sure we have a short path...
 FMLongToShort filePath$, p$
 'and make sure the attributes won't get in the way (like read only)
 FMSetAttributes p$, 0
 kill p$
end sub





defint a-z
SUB FMDeleteDir (filePath$)
 'make sure we have a short path...
 FMLongToShort filePath$, p$
 rmdir p$
END SUB





defint a-z
SUB FMGetAttributes(path$, attribs)
 ' 7	shareable (Novell NetWare)
 ' 	pending deleted files (Novell DOS, OpenDOS)
 ' 6	unused
 ' 5	archive
 ' 4	directory
 ' 3	volume label
 '	execute-only (Novell NetWare)
 ' 2	system
 ' 1	hidden
 ' 0	read-only
 xcx?? = 0
 fileName$ = path$ + chr$(0)
 fSeg?? = strseg(fileName$)
 fPtr?? = strptr(fileName$)
 !mov ax, &h4300
 !push ds
 !mov ds, fSeg??
 !mov dx, fPtr??
 !int &h21
 !pop ds
 !mov xcx??, cx
 attribs = xcx??
END SUB





defint a-z
SUB FMSetAttributes(path$, attribs)
 xcx?? = attribs
 FMLongToShort path$, p$
 fileName$ = p$ + chr$(0)
 fSeg?? = strseg(fileName$)
 fPtr?? = strptr(fileName$)
 !mov ax, &h4301
 !mov cx, xcx??
 !push ds
 !mov ds, fSeg??
 !mov dx, fPtr??
 !int &h21
 !pop ds
END SUB





defint a-z
SUB FMShortToLong (pathA$, pathB$)
 path1$ = pathA$ + chr$(0)
 path2$ = string$(272, 32)
 oSeg?? = strseg(path1$)
 oPtr?? = strptr(path1$)
 nSeg?? = strseg(path2$)
 nPtr?? = strptr(path2$)
 !mov ax, &h7160
 !mov cx, &h8002
 !push ds
 !mov ds, oSeg??
 !mov si, oPtr??
 !mov es, nSeg??
 !mov di, nPtr??
 !int &h21
 !pop ds
 pathB$ = rtrim$(path2$, any chr$(0) + " ")
 if pathB$ = "" then pathB$ = pathA$
END SUB





defint a-z
SUB FMLongToShort (pathA$, pathB$)
 path1$ = pathA$ + chr$(0)
 path2$ = string$(256, 32)
 oSeg?? = strseg(path1$)
 oPtr?? = strptr(path1$)
 nSeg?? = strseg(path2$)
 nPtr?? = strptr(path2$)
 !mov ax, &h7160
 !mov cx, &h8001
 !push ds
 !mov ds, oSeg??
 !mov si, oPtr??
 !mov es, nSeg??
 !mov di, nPtr??
 !int &h21
 !pop ds
 pathB$ = rtrim$(path2$, any chr$(0) + " ")
 if pathB$ = "" then pathB$ = pathA$
END SUB





defint a-z
sub FMFlushBuffer (fileNum)
'test
 FMLookupDataByNumber threadNum, filePath$, fileNum
 seekTo& = seek(fileNum)
 close fileNum
 open filePath$ for binary as fileNum
 seek (fileNum), seekTo&
end sub





defint a-z
sub FMSubstCreate (drive$, filePath$)
 'this function is natively lfn compatible
 d?? = asc(lcase$(left$(drive$, 1))) - 96
 fp$ = filePath$ + chr$(0)
 fSeg?? = strseg(fp$)
 fPtr?? = strptr(fp$)
 !mov ax, &h71AA
 !mov bl, d??
 !mov bh, 0
 !push ds
 !mov ds, fSeg??
 !mov dx, fPtr??
 !int &h21
 !pop ds
end sub





defint a-z
sub FMSubstQuery (drive$, filePath$)
 'this function is natively lfn compatible
 d?? = asc(lcase$(left$(drive$, 1))) - 96
 fp$ = string$(300, 32)
 fSeg?? = strseg(fp$)
 fPtr?? = strptr(fp$)
 !mov ax, &h71AA
 !mov bl, d??
 !mov bh, 2
 !push ds
 !mov ds, fSeg??
 !mov dx, fPtr??
 !int &h21
 !pop ds
 filePath$ = rtrim$(fp$)
end sub





defint a-z
sub FMSubstTerminate (drive$)
 'this function is natively lfn compatible
 d?? = asc(lcase$(left$(drive$, 1))) - 96
 !mov ax, &h71AA
 !mov bl, d??
 !mov bh, 1
 !int &h21
end sub





defint a-z
sub FMGetFSData (drive$, serial???, volLabel$, fsType$)
 volLabel$ = ""
 fsType$ = ""
 d?? = asc(lcase$(left$(drive$, 1))) - 96
 dim x(0 to 31) as byte
 xSeg?? = varseg(x(0))
 xPtr?? = varptr(x(0))
 xax?? = 0
 !mov ah, &h69
 !mov al, &h00
 !mov bl, d??
 !mov bh, 00
 !push ds
 !mov ds, xSeg??
 !mov dx, xPtr??
 !int &h21
 !pop ds
 !mov xax??, ax
 serial??? = x(2) + (x(3) * 256) + (x(4) * 65536) + (x(5) * 16777216)
 for a = 6 to 16
  volLabel$ = volLabel$ + chr$(x(a))
 next
 volLabel$ = rtrim$(volLabel$)
 if volLabel$ = "NO NAME" then volLabel$ = ""
 for a = 17 to 31
  fsType$ = fsType$ + chr$(x(a))
 next
 fsType$ = rtrim$(fsType$, any chr$(0) + " ")
 dwordtohex serial???, s$
 ?s$,volLabel$,fsType$:?
 'values for fsType$
 'FAT12		12-bit FAT
 'FAT16		16-bit FAT
 'FAT32		32-bit FAT
 'NTFS		NTFS
 'CDROM		High-Sierra CD-ROM filesystem
 'CD001		ISO 9660 CD-ROM filesystem
 'CDAUDIO	audio CD
end sub





defint a-z
sub FMLookupDataByNumber (threadNum, filePath$, fileNum)
'test
 threadNum = 0
 filePath$ = ""
 for x = lbound(fileRecord) to ubound(fileRecord)
  if fileRecord(x).fileNum = fileNum then
   threadNum = fileRecord(x).threadNum
   filePath$ = fileRecord(x).filePath$
   exit sub
  end if
 next
end sub





defint a-z
sub FMLookupDataByPath (threadNum, filePath$, fileNum)
'test
 threadNum = 0
 fileNum = 0
 for x = lbound(fileRecord) to ubound(fileRecord)
  if rtrim$(rtrim$(fileRecord(x).filePath$), chr$(0)) = filePath$ then
   threadNum = fileRecord(x).threadNum
   fileNum = fileRecord(x).fileNum
   exit sub
  end if
 next
end sub





'misc





sub DWORDToHex (num???, hexStr$)
 ptr?? = varptr(num???)
 byte1 = peek(ptr?? + 3)
 byte2 = peek(ptr?? + 2)
 byte3 = peek(ptr?? + 1)
 byte4 = peek(ptr??)
 if byte1 < 16 then
  byte1$ = "0" + hex$(byte1)
 else
  byte1$ = hex$(byte1)
 end if
 if byte2 < 16 then
  byte2$ = "0" + hex$(byte2)
 else
  byte2$ = hex$(byte2)
 end if
 if byte3 < 16 then
  byte3$ = "0" + hex$(byte3)
 else
  byte3$ = hex$(byte3)
 end if
 if byte4 < 16 then
  byte4$ = "0" + hex$(byte4)
 else
  byte4$ = hex$(byte4)
 end if
 hexStr$ = byte1$ + byte2$ + byte3$ + byte4$
end sub