'PCOS Kernel Text Module (textmod.bas) version 2.0
'Copyright 1995-2008 by Mercury0x000D

'textmod.bas is a part of the PCOS Kernel

'The PCOS Kernel is free software: you can redistribute it and/or modify
'it under the terms of the GNU General Public License as published by
'the Free Software Foundation, either version 3 of the License, or
'(at your option) any later version.

'The PCOS Kernel is distributed in the hope that it will be useful,
'but WITHOUT ANY WARRANTY; without even the implied warranty of
'MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
'GNU General Public License for more details.

'You should have received a copy of the GNU General Public License
'along with the PCOS Kernel.  If not, see <http://www.gnu.org/licenses/>.

'See the included file <GPL License.txt> for the complete text of the
'GPL License by which this program is covered.





defint a-z
$dynamic
'XMS Manager globals
type handleListType
 threadNum as dword		'number of the allocating thread
 handle as dword
 blockSize as dword
end type

type xmsVarType
 '16 bytes
 size as dword
 sourceHandle as word
 sourceOffset as dword
 destHandle as word
 destOffset as dword
end type
dim handleList (0 to 63) as handleListType
shared handleList()
dim xmsVar as xmsVarType
shared xmsDriverAddr???, xmsVar, xmsDriverSeg??, xmsDriverPtr??





defint a-z
sub TMNewStringHandle (handle???, optionalText$, xmsErr???)
 a$ = mkdwd$(len(optionalText$)) + optionalText$
 XMAllocateFilled 1, handle???, 32, xmsErr???
 if xmsErr??? <> 0 then exit sub
 TMSetStringLength handle???, len(a$), xmsErr???
 if xmsErr??? <> 0 then exit sub
 XMWrite handle???, 0, a$, len(a$), xmsErr???
end sub





defint a-z
sub TMGetString (handle???, theStr$, xmsErr???)
 'the string returned can be upto 32750 characters long
 TMGetStringLength handle???, length???, xmsErr???
 if xmsErr??? <> 0 then exit sub
 if length??? > 32750 then exit sub
 theStr$ = string$(length???, 32)
 XMRead handle???, 4, theStr$, length???, xmsErr???
end sub





defint a-z
sub TMSetString (handle???, theStr$, xmsErr???)
 'the string can be upto 32750 characters long
 length??? = len(theStr$)
 if length??? > 32750 then exit sub
 XMWrite handle???, 4, theStr$, length???, xmsErr???
 if xmsErr??? <> 0 then exit sub
 TMSetStringLength handle???, length???, xmsErr???
end sub





defint a-z
sub TMGetStringLength (handle???, length???, xmsErr???)
 length??? = 0
 x$ = "    "
 XMRead handle???, 0, x$, 4, xmsErr???
 if xmsErr??? <> 0 then exit sub
 length??? = cvdwd(x$)
end sub





defint a-z
sub TMSetStringLength (handle???, length???, xmsErr???)
 x$ = mkdwd$(length???)
 XMWrite handle???, 0, x$, 4, xmsErr???
end sub





defint a-z
sub TMInsertStr (handle???, insertPos???, strHandle???, xmsErr???)
 'this function requires a free xms handle to work properly
 'it will increase the size of the main handle if needed

 TMGetStringLength handle???, size???, xmsErr???
 if xmsErr??? <> 0 then exit sub

 TMGetStringLength strHandle???, strSize???, xmsErr???
 if xmsErr??? <> 0 then exit sub

 charPos??? = insertPos??? + 4
 charsBefore??? = 4 + charPos??? - 1
 charsAfter??? = 4 + size??? - charPos???
 charAfterPos??? = charPos??? + strSize???
 newSize??? = size??? + strSize???

 'allocate a handle to hold the end of the string
 xmsRequest??? = (charsAfter??? / 1024) + 1
 XMAllocateFilled xmsRequest???, afterHandle???, 32, xmsErr???
 if xmsErr??? <> 0 then exit sub

 'copy the end of the string to the new handle
 XMCopy handle???, charPos???, charsAfter???, afterHandle???, 0, xmsErr???
 if xmsErr??? <> 0 then exit sub

 'here we resize the main handle if needed
 XMBlockSize handle???, currentSize???, xmsErr???
 if xmsErr??? <> 0 then exit sub
 if newSize??? + strSize??? > currentSize??? then
  XMChangeBlockSize handle???, newSize???, xmsErr???
  if xmsErr??? <> 0 then exit sub
 end if

 'now we write the string to be inserted into the main string
 XMCopy strHandle???, 4, strSize???, handle???, charPos???, xmsErr???
 if xmsErr??? <> 0 then exit sub

 'then copy the end of the string back onto the main string
 XMCopy afterHandle???, 0, charsAfter???, handle???, charAfterPos???, xmsErr???
 if xmsErr??? <> 0 then exit sub

 'update the main string's length
 TMSetStringLength handle???, newSize???, xmsErr???
 if xmsErr??? <> 0 then exit sub

 'mustn't forget to give back the other handle we allocated
 XMRelease afterHandle???, xmsErr???
end sub





defint a-z
sub TMOverwriteStr (handle???, insertPos???, strHandle???, xmsErr???)
 'this function will increase the size of the main handle if needed

 TMGetStringLength handle???, size???, xmsErr???
 if xmsErr??? <> 0 then exit sub

 TMGetStringLength strHandle???, strSize???, xmsErr???
 if xmsErr??? <> 0 then exit sub

 charPos??? = insertPos??? + 4
 charsBefore??? = 4 + charPos??? - 1
 if insertPos??? + strSize??? - 1 > size??? then
  newSize??? = insertPos??? + strSize??? - 1
 else
  newSize??? = size???
 end if

 'here we resize the main handle if needed
 XMBlockSize handle???, currentSize???, xmsErr???
 if xmsErr??? <> 0 then exit sub
 if newSize??? + strSize??? > currentSize??? then
  XMChangeBlockSize handle???, newSize???, xmsErr???
  if xmsErr??? <> 0 then exit sub
 end if

 'now we write the string to be inserted into the main string
 XMCopy strHandle???, 4, strSize???, handle???, charPos???, xmsErr???
 if xmsErr??? <> 0 then exit sub

 'update the main string's length
 TMSetStringLength handle???, newSize???, xmsErr???
end sub





defint a-z
sub TMReplaceRange (sourceHandle???, rangeStart???, rangeEnd???, replaceHandle???, xmsErr???)
 'this function requires a free xms handle to work properly
 'it will increase the size of the main handle if needed

 TMGetStringLength sourceHandle???, size???, xmsErr???
 if xmsErr??? <> 0 then exit sub

 TMGetStringLength replaceHandle???, replaceSize???, xmsErr???
 if xmsErr??? <> 0 then exit sub

 stringEndLength??? = size??? - rangeEnd???
 newSize??? = size??? - (rangeEnd??? - rangeStart??? + 1) + replaceSize???

 'allocate a handle to hold the end of the string
 xmsRequest??? = (stringEndLength??? / 1024) + 1
 XMAllocateFilled xmsRequest???, afterHandle???, 32, xmsErr???
 if xmsErr??? <> 0 then exit sub

 'copy the end of the string to the new handle
 XMCopy sourceHandle???, 3 + rangeEnd??? + 1, stringEndLength???, afterHandle???, 0, xmsErr???
 if xmsErr??? <> 0 then exit sub

 'here we resize the main handle if needed
 XMBlockSize sourceHandle???, currentSize???, xmsErr???
 if xmsErr??? <> 0 then exit sub
 if newSize??? > size??? then
  XMChangeBlockSize sourceHandle???, newSize???, xmsErr???
  if xmsErr??? <> 0 then exit sub
 end if

 'now we write the string to be inserted into the main string
 XMCopy replaceHandle???, 4, replaceSize???, sourceHandle???, 3 + rangeStart???, xmsErr???
 if xmsErr??? <> 0 then exit sub

 'then copy the end of the string back onto the main string
 XMCopy afterHandle???, 0, stringEndLength???, sourceHandle???, 3 + rangeStart??? + replaceSize???, xmsErr???
 if xmsErr??? <> 0 then exit sub

 'update the main string's length
 TMSetStringLength sourceHandle???, newSize???, xmsErr???
 if xmsErr??? <> 0 then exit sub

 'mustn't forget to give back the other handle we allocated
 XMRelease afterHandle???, xmsErr???
end sub





defint a-z
sub TMDeleteRange (handle???, rangeStart???, rangeEnd???, xmsErr???)
 TMGetStringLength handle???, size???, xmsErr???
 if xmsErr??? <> 0 then exit sub

 stringEndLength??? = size??? - rangeEnd???

 'copy the string, overwriting the range...
 XMCopy handle???, 4 + rangeEnd???, stringEndLength???, handle???, 3 + rangeStart???, xmsErr???
 if xmsErr??? <> 0 then exit sub

 'update the main string's length
 newSize??? = (size??? - (rangeEnd??? - rangeStart??? + 1))
 TMSetStringLength handle???, newSize???, xmsErr???
end sub





defint a-z
sub TMSearchString (sourceHandle???, matchHandle???, startPos???, matchPos???, xmsErr???)
 'The matchHandle??? string cannot be over 32750 bytes long.

 matchPos??? = 0

 'load up matchString$...
 TMGetStringLength matchHandle???, length???, xmsErr???
 if xmsErr??? <> 0 then exit sub
 if length??? > 32750 then exit sub
 matchString$ = string$(length???, 32)
 XMRead matchHandle???, 4, matchString$, length???, xmsErr???
 if xmsErr??? <> 0 then exit sub

 'now we get the length of sourceHandle???
 TMGetStringLength sourceHandle???, size???, xmsErr???
 if xmsErr??? <> 0 then exit sub

 testString$ = matchString$

 if startPos??? <> 0 then
  start??? = startPos???
 else
  start??? = 1
 end if

 for a??? = start??? to size???
  XMRead sourceHandle???, 3 + a???, testString$, length???, xmsErr???
  if xmsErr??? <> 0 then exit sub
  if testString$ = matchString$ then
   matchPos??? = a???
   exit sub
  end if
 next
end sub





defint a-z
sub TMLeft (sourceHandle???, length???, destHandle???, xmsErr???)
 XMCopy sourceHandle???, 4, length???, destHandle???, 4, xmsErr???
 if xmsErr??? <> 0 then exit sub
 'update the length of the dest string
 TMSetStringLength destHandle???, length???, xmsErr???
end sub





defint a-z
sub TMRight (sourceHandle???, length???, destHandle???, xmsErr???)
 'get the length of the source string
 TMGetStringLength sourceHandle???, size???, xmsErr???
 if xmsErr??? <> 0 then exit sub

 startPos??? = 4 + size??? - length???
 XMCopy sourceHandle???, startPos???, length???, destHandle???, 4, xmsErr???
 if xmsErr??? <> 0 then exit sub
 'update the length of the dest string
 TMSetStringLength destHandle???, length???, xmsErr???
end sub





defint a-z
sub TMMid (sourceHandle???, startPos???, length???, destHandle???, xmsErr???)
 XMCopy sourceHandle???, 3 + startPos???, length???, destHandle???, 4, xmsErr???
 if xmsErr??? <> 0 then exit sub
 'update the length of the dest string
 TMSetStringLength destHandle???, length???, xmsErr???
end sub





defint a-z
sub TMGetWord (sourceHandle???, wordNum, strWhere???, sepHandle???, destHandle???, xmsErr???)
 'This routine returns the specified word out of a string (specified by
 'sourceHandle???) divided into words by the seperator list (specified by
 'sepHandle???) which can be a list of characters or a single character, and
 'returns the position where it found the specified word in strWhere???.
 'The word seperator list (sepHandle???) must be 32750 characters or less.

 'first we get the length of the source string
 TMGetStringLength sourceHandle???, size???, xmsErr???
 if xmsErr??? <> 0 then exit sub

 'no point in continuing if the string's empty, huh?
 IF size??? = 0 then exit sub

 'load sepHandle??? into sep$
 TMGetString sepHandle???, sep$, xmsErr???
 if xmsErr??? <> 0 then exit sub

 x$ = "  "
 xmsVar.size = 2
 xmsVar.sourceHandle = sourceHandle???
 xmsVar.destHandle = 0
 xmsVar.destOffset = strPtr32(x$)
 xmsVarSeg?? = varseg(xmsVar)
 xmsVarPtr?? = varptr(xmsVar)

 for a??? = 4 to 3 + size???
  xmsVar.sourceOffset = a???
   !mov ds, xmsVarSeg??
  !mov si, xmsVarPtr??
  !mov ah, 11
  !call xmsDriverAddr???
  b$ = left$(x$, 1)
  if instr(b$, any sep$) = 1 then
   if instr(lastChar$, any sep$) = 0 then
    aa$ = aa$ + b$
   end if
  else
   aa$ = aa$ + b$
  end if
  lastChar$ = b$
 next
 aa$ = aa$ + left$(sep$, 1)
 for a = 1 to len(aa$)
  b$ = mid$(aa$, a, 1)
  if instr(b$, any sep$) = 1 then
   d$ = c$
   c$ = ""
   word = word + 1
   if word = wordNum then
    TMSetString destHandle???, d$, xmsErr???
    strWhere??? = a??? - len(d$)
    exit sub
   end if
  else
   c$ = c$ + b$
  end if
 next

 'nothing was found, so we write null length to the destHandle
 x$ = mkdwd$(0)
 XMWrite destHandle???, 0, x$, 4, xmsErr???
end sub





defint a-z
sub TMUppercase (sourceHandle???, startPos???, length???, destHandle???, xmsErr???)
 'get the length of the source string
 TMGetStringLength sourceHandle???, size???, xmsErr???
 if xmsErr??? <> 0 then exit sub

 'copy the source string into the dest string
 XMCopy sourceHandle???, 0, 4 + size???, destHandle???, 0, xmsErr???
 if xmsErr??? <> 0 then exit sub

 if length??? <= 32750 then
  copyStr$ = string$(length???, 0)
  copyAmount??? = length???
 else
  copyStr$ = string$(32750, 0)
  copyAmount??? = 32750
 end if

 do while completed??? < length???
  XMRead sourceHandle???, 3 + startPos??? + completed???, copyStr$, copyAmount???, xmsErr???
  if xmsErr??? <> 0 then exit sub
  copyStr$ = ucase$(copyStr$)
  XMWrite destHandle???, 3 + startPos??? + completed???, copyStr$, copyAmount???, xmsErr???
  if xmsErr??? <> 0 then exit sub
  completed??? = completed??? + copyAmount???
 loop
end sub





defint a-z
sub TMLowercase (sourceHandle???, startPos???, length???, destHandle???, xmsErr???)
 'get the length of the source string
 TMGetStringLength sourceHandle???, size???, xmsErr???
 if xmsErr??? <> 0 then exit sub

 'copy the source string into the dest string
 XMCopy sourceHandle???, 0, 4 + size???, destHandle???, 0, xmsErr???
 if xmsErr??? <> 0 then exit sub

 if length??? <= 32750 then
  copyStr$ = string$(length???, 0)
  copyAmount??? = length???
 else
  copyStr$ = string$(32750, 0)
  copyAmount??? = 32750
 end if

 do while completed??? < length???
  XMRead sourceHandle???, 3 + startPos??? + completed???, copyStr$, copyAmount???, xmsErr???
  if xmsErr??? <> 0 then exit sub
  copyStr$ = lcase$(copyStr$)
  XMWrite destHandle???, 3 + startPos??? + completed???, copyStr$, copyAmount???, xmsErr???
  if xmsErr??? <> 0 then exit sub
  completed??? = completed??? + copyAmount???
 loop
end sub





defint a-z
sub TMTrimLeft (handle???, trimList???, xmsErr???)
 'The trimList??? string cannot be over 32750 bytes long.

 'load the trimList$...
 TMGetStringLength trimList???, length???, xmsErr???
 if length??? > 32750 then exit sub
 TMGetString trimList???, trimList$, xmsErr???
 if xmsErr??? <> 0 then exit sub

 'now we get the length of the handle??? string
 TMGetStringLength handle???, size???, xmsErr???
 if xmsErr??? <> 0 then exit sub

 x$ = "  "

 for a??? = 1 to size???
  XMRead handle???, 3 + a???, x$, 2, xmsErr???
  if xmsErr??? <> 0 then exit sub
  if instr(left$(x$, 1), any trimList$) = 0 then
   'copy this spot to the end of the string to the beginning
   copyLength??? = size??? - a??? + 1
   XMCopy handle???, 3 + a???, copyLength???, handle???, 4, xmsErr???
   if xmsErr??? <> 0 then exit sub
   'set the new string length
   TMSetStringLength handle???, copyLength???, xmsErr???
   if xmsErr??? <> 0 then exit sub
   exit sub
  end if
 next
end sub





defint a-z
sub TMTrimRight (handle???, trimList???, xmsErr???)
 'The trimList??? string cannot be over 32750 bytes long.

 'load the trimList$...
 TMGetStringLength trimList???, length???, xmsErr???
 if xmsErr??? <> 0 then exit sub
 if length??? > 32750 then exit sub
 TMGetString trimList???, trimList$, xmsErr???
 if xmsErr??? <> 0 then exit sub

 'now we get the length of the handle??? string
 TMGetStringLength handle???, size???, xmsErr???
 if xmsErr??? <> 0 then exit sub

 x$ = "  "
 for a??? = 0 to size??? - 1
  'we have to do it this way to compensate for PowerBASIC's stupid 'unsigned
  'integer counters can't have a negative step value' bug
  b??? = size??? - a???
  XMRead handle???, 3 + b???, x$, 2, xmsErr???
  if xmsErr??? <> 0 then exit sub
  if instr(left$(x$, 1), any trimList$) = 0 then
   'set this spot as the new length of the string
   TMSetStringLength handle???, b???, xmsErr???
   if xmsErr??? <> 0 then exit sub
   exit sub
  end if
 next
end sub





defint a-z
sub TMStripChars (handle???, charList???, rangeStart???, rangeEnd???, xmsErr???)
 'the charList string must be 32750 characters long or less
 'this routine requires a free xms handle to function properly

 'get the length of charList and load it
 TMGetStringLength charList???, length???, xmsErr???
 if xmsErr??? <> 0 then exit sub
 if length??? > 32750 then exit sub
 TMGetString charList???, charList$, xmsErr???
 if xmsErr??? <> 0 then exit sub

 'get the length of handle???
 TMGetStringLength handle???, size???, xmsErr???
 if xmsErr??? <> 0 then exit sub

 'allocate a handle to hold the end of the string
 xmsRequest??? = (size??? / 1024) + 1
 XMAllocateFilled xmsRequest???, tempHandle???, 32, xmsErr???
 if xmsErr??? <> 0 then exit sub

 if rangeStart??? = 0 then
  startPos??? = 1
 else
  startPos??? = rangeStart???
 end if

 if rangeEnd??? = 0 then
  endPos??? = size???
 else
  endPos??? = rangeEnd???
 end if

 x$ = "  "
 tempHandlePos??? = 4

 for a??? = startPos??? to endPos???
  XMRead handle???, 3 + a???, x$, 2, xmsErr???
  if xmsErr??? <> 0 then exit sub
  if instr(left$(x$, 1), any charList$) = 0 then
   tempString$ = tempString$ + left$(x$, 1)
   if len(tempString$) = 32750 then
    'dump the buffer to XMS
    XMWrite tempHandle???, tempHandlePos???, tempString$, 32750, xmsErr???
    if xmsErr??? <> 0 then exit sub
    tempHandlePos??? = tempHandlePos??? + 32750
    tempString$ = ""
   end if
  end if
 next
 if tempString$ <> "" then
  'once again, we dump the rest to XMS
  XMWrite tempHandle???, tempHandlePos???, tempString$, len(tempString$), xmsErr???
  if xmsErr??? <> 0 then exit sub
  tempHandlePos??? = tempHandlePos??? + len(tempString$)
 end if

 'copy the tempString back into the main one
 tempHandlePos??? = tempHandlePos??? - 4
 XMCopy tempHandle???, 4, tempHandlePos???, handle???, 4, xmsErr???
 if xmsErr??? <> 0 then exit sub
 TMSetStringLength handle???, tempHandlePos???, xmsErr???
 if xmsErr??? <> 0 then exit sub

 'free the temp handle we allocated
 XMRelease tempHandle???, xmsErr???
end sub





defint a-z
sub TMGetASC (handle???, chrPos???, code???, xmsErr???)
 x$ = " "
 XMRead handle???, 3 + chrPos???, x$, 1, xmsErr???
 if xmsErr??? <> 0 then exit sub
 code??? = asc(x$)
end sub



































'--------------------
'XMS Manager routines
'--------------------





defint a-z
SUB XMInit (successFlag, xmsHandlesAvailable, handlesLimitedBy)
 successFlag = 0
 xmsHandlesAvailable = 0
 xmsDriverAddr??? = 0
 'check for XMS driver...
 xmsInst = 0
 !mov ax, &h4300
 !int &h2F
 !mov xmsInst, al
 if xmsInst <> &h80 then exit sub
 'get the address of the XMS driver
 !mov ax, &h4310
 !int &h2F
 !mov xmsDriverSeg??, es
 !mov xmsDriverPtr??, bx
 xmsDriverAddr??? = xmsDriverSeg?? * 65536 + xmsDriverPtr??
 successFlag = 1
 'here we check to see how many handles we have at our disposal
 dim xmsHandleTemp???(0 to 1023)
 for aa??? = 0 to 65535
  XMAllocate 1, handle???, xmsErr???
  if xmsErr??? = &hA0 then handlesLimitedBy = 1:exit for
  if xmsErr??? = &hA1 then handlesLimitedBy = 2:exit for
  if xmsErr??? = 0 then incr xmsHandlesAvailable
  if counter <= ubound(xmsHandleTemp???) then
   xmsHandleTemp???(counter) = handle???
   counter = counter + 1
  end if
 next
 'NOW WE GIVE BACK ALL THE HANDLES AND ERASE THE ARRAY THAT HELD THEM...
 for aa = 0 to counter - 1
  XMRelease xmsHandleTemp???(aa), xmsErr???
 next
 erase xmsHandleTemp???
END SUB





DEFINT A-Z
SUB XMMemoryAvailable (xmsFree???)
 xmsFree??? = 0
 listMax = 1023
 dim handles???(0 to listMax)
 gosub XMSAvailGetXMS
 do while xmsLFB?? <> 0
  xmsSize??? = xmsLFB??
  XMAllocate xmsSize???, handles???(counter), xmsErr???
  if xmsErr??? = 0 then
   counter = counter + 1
   xmsFree??? = xmsFree??? + xmsLFB??
   gosub XMSAvailGetXMS
  else
   exit do
  end if
 loop
 for a = 0 to listMax
  if handles???(a) <> 0 then XMRelease handles???(a), xmsErr???
 next
 erase handles???
 xmsErr??? = 0
 exit sub
 XMSAvailGetXMS:
  xax = 0
  xbl = 0
  xmsErr??? = 0
  xmsLFB?? = 0
  !mov ah, 8
  !call xmsDriverAddr???
  !mov xmsLFB??, ax
  !mov xax, ax
  !mov xbl, bl
  if xax = 0 then xmsErr??? = xbl
 return
END SUB





DEFINT A-Z
SUB XMAllocate (xmsSize???, handle???, xmsErr???)
 xax = 0
 xbl = 0
 xmsErr??? = 0
 xmsRequest??? = xmsSize???
 xmsHandle??? = 0
 !mov ah, 9
 !mov dx, xmsRequest???
 !call xmsDriverAddr???
 !mov xax, ax
 !mov xbl, bl
 if xax = 0 then
  xmsErr??? = xbl
  exit sub
 end if
 'the allocation was successful, so we proceed...
 !mov xmsHandle???, dx
 handle??? = xmsHandle???
 'find a free slot in the handles list...
 freeSlot = -1
 for a = lbound(handleList) to ubound(handleList)
  if handleList(a).handle = 0 then
   freeSlot = a
   exit for
  end if
 next
 if freeSlot = -1 then
  'no slot found; increase the size of the list
  dim temp(lbound(handleList) to ubound(handleList)) as handleListType
  for x = lbound(handleList) to ubound(handleList)
   temp(x) = handleList(x)
  next
  redim handleList(lbound(temp) to ubound(temp) + 1)
  for x = lbound(temp) to ubound(temp)
   handleList(x) = temp(x)
  next
  erase temp()
  freeSlot = ubound(handleList)
 end if
 handleList(freeSlot).threadNum = threadNum
 handleList(freeSlot).handle = handle???
 handleList(freeSlot).blockSize = xmsSize???
END SUB





DEFINT A-Z
SUB XMAllocateFilled (xmsSize???, handle???, fillChar, xmsErr???)
 xax = 0
 xbl = 0
 xmsErr??? = 0
 xmsRequest??? = xmsSize???
 xmsHandle??? = 0
 !mov ah, 9
 !mov dx, xmsRequest???
 !call xmsDriverAddr???
 !mov xax, ax
 !mov xbl, bl
 if xax = 0 then
  xmsErr??? = xbl
  exit sub
 end if
 !mov xmsHandle???, dx
 handle??? = xmsHandle???
 'begin wiping the block...
 totalAmount??? = xmsSize??? * 1024
 if totalAmount??? < 32750 then
  a$ = string$(totalAmount???, fillChar)
 else
  a$ = string$(32750, fillChar)
 end if
 do until clearedAmount??? = totalAmount???
  XMWrite handle???, clearedAmount???, a$, len(a$), xmsErr???
  clearedAmount??? = clearedAmount??? + len(a$)
  if totalAmount??? - clearedAmount??? < 32750 then
   a$ = string$(totalAmount??? - clearedAmount???, fillChar)
  end if
 loop
 'find a free slot in the handles list...
 freeSlot = -1
 for a = lbound(handleList) to ubound(handleList)
  if handleList(a).handle = 0 then
   freeSlot = a
   exit for
  end if
 next
 if freeSlot = -1 then
  'no slot found; increase the size of the list
  dim temp(lbound(handleList) to ubound(handleList)) as handleListType
  for x = lbound(handleList) to ubound(handleList)
   temp(x) = handleList(x)
  next
  redim handleList(lbound(temp) to ubound(temp) + 1)
  for x = lbound(temp) to ubound(temp)
   handleList(x) = temp(x)
  next
  erase temp()
  freeSlot = ubound(handleList)
 end if
 handleList(freeSlot).threadNum = threadNum
 handleList(freeSlot).handle = handle???
 handleList(freeSlot).blockSize = xmsSize???
END SUB





DEFINT A-Z
SUB XMRelease (handle???, xmsErr???)
 xax = 0
 xbl = 0
 xmsErr??? = 0
 xmsHandle??? = handle???
 !mov ah, 10
 !mov dx, xmsHandle???
 !call xmsDriverAddr???
 !mov xax, ax
 !mov xbl, bl
 if xax = 0 then xmsErr??? = xbl
 'remove the entry from the handle list...
 for a = lbound(handleList) to ubound(handleList)
  if handleList(a).handle??? = handle??? then
   deleteSlot = a
   exit for
  end if
 next
 'zero out the variables here... maybe this is being paranoid, since they
 'get overwritten afterwards anyway
 handleList(deleteSlot).threadNum = 0
 handleList(deleteSlot).handle??? = 0
 handleList(deleteSlot).blockSize = 0
 if ubound(handleList) - lbound(handleList) > 63 then
  'shrink the list by one, save memory...
  dim temp(lbound(handleList) to ubound(handleList) - 1) as handleListType
  counter = lbound(temp)
  for x = lbound(handleList) to ubound(handleList)
   if x <> deleteSlot then
    temp(counter) = handleList(x)
    counter = counter + 1
   end if
  next
  redim handleList(lbound(temp) to ubound(temp))
  for x = lbound(temp) to ubound(temp)
   handleList(x) = temp(x)
  next
  erase temp()
 end if
END SUB





DEFINT A-Z
SUB XMReleaseAll (threadNum???, xmsErr???)
 for x = lbound(handleList) to ubound(handleList)
  if x >= lbound(handleList) and x <= ubound(handleList) then
   if handleList(x).threadNum = threadNum??? then
    XMRelease handleList(x).handle, xmsErr???
   end if
  end if
 next
end sub





DEFINT A-Z
SUB XMBlockSize (handle???, size???, xmsErr???)
 'returns block size in KB
 for a = lbound(handleList) to ubound(handleList)
  if handleList(a).handle = handle??? then
   size??? = handleList(a).blockSize
  end if
 next
END SUB





DEFINT A-Z
SUB XMChangeBlockSize (handle???, newSize???, xmsErr???)
 if newSize??? > 65535 then xmsErr??? = &hA7:exit sub
 xax = 0
 xbl = 0
 xmsErr??? = 0
 nSize?? = newSize???
 xmsHandle?? = handle???
 !mov ah, &h0F
 !mov bx, nSize??
 !mov dx, xmsHandle??
 !call xmsDriverAddr???
 !mov xax, ax
 !mov xbl, bl
 if xax = 0 then xmsErr??? = xbl
END SUB





DEFINT A-Z
SUB XMRead (handle???, addr???, xData$, dataLength???, xmsErr???)
 length??? = dataLength???
 xax = 0
 xbl = 0
 xmsErr??? = 0
 'not all xms drivers check to see if the tranfer length is even or odd, so
 'we have to enforce this rule on our own
 if length??? / 2 - int(length??? / 2) <> 0 then
  flag = 1
  length??? = length??? + 1
  xData$ = xData$ + " "
 end if
 xmsVar.size = length???
 xmsVar.sourceHandle = handle???
 xmsVar.sourceOffset = addr???
 xmsVar.destHandle = 0
 xmsVar.destOffset = strPtr32(xData$)
 xmsVarSeg?? = varseg(xmsVar)
 xmsVarPtr?? = varptr(xmsVar)
 !push ds
 !mov ds, xmsVarSeg??
 !mov si, xmsVarPtr??
 !mov ah, 11
 !call xmsDriverAddr???
 !pop ds
 !mov xax, ax
 !mov xbl, bl
 if xax = 0 then xmsErr??? = xbl
 if flag = 1 then xData$ = left$(xData$, length??? - 1)
END SUB





DEFINT A-Z
SUB XMWrite (handle???, addr???, xData$, dataLength???, xmsErr???)
 x$ = ""
 length??? = dataLength???
 xax = 0
 xbl = 0
 xmsErr??? = 0
 'once again, we enforce the even length tranfer rule...
 if length??? / 2 - int(length??? / 2) <> 0 then
  length??? = length??? + 1
  x$ = string$(length???, 32)
  XMRead handle???, addr???, x$, length???, xmsErr???
  x$ = xData$ + right$(x$, 1)
 else
  x$ = xData$
 end if
 xmsVar.size = length???
 xmsVar.sourceHandle = 0
 xmsVar.sourceOffset = strPtr32(x$)
 xmsVar.destHandle = handle???
 xmsVar.destOffset = addr???
 xmsVarSeg?? = varseg(xmsVar)
 xmsVarPtr?? = varptr(xmsVar)
 !mov si, xmsVarPtr??
 !mov ah, 11
 !push ds
 !mov ds, xmsVarSeg??
 !call xmsDriverAddr???
 !pop ds
 !mov xax, ax
 !mov xbl, bl
 if xax = 0 then xmsErr??? = xbl
END SUB





DEFINT A-Z
SUB XMCopy (handle1???, addr1???, dataLength???, handle2???, addr2???, xmsErr???)
 length??? = dataLength???
 xax = 0
 xbl = 0
 xmsErr??? = 0
 if length??? / 2 - int(length??? / 2) <> 0 then
  'and again we enforce the even length rule...
  flag = 1
  length??? = length??? - 1
 end if
 xmsVar.size = length???
 xmsVar.sourceHandle = handle1???
 xmsVar.sourceOffset = addr1???
 xmsVar.destHandle = handle2???
 xmsVar.destOffset = addr2???
 xmsVarSeg?? = varseg(xmsVar)
 xmsVarPtr?? = varptr(xmsVar)
 !push ds
 !mov ds, xmsVarSeg??
 !mov si, xmsVarPtr??
 !mov ah, 11
 !call xmsDriverAddr???
 !pop ds
 !mov xax, ax
 !mov xbl, bl
 if xax = 0 then xmsErr??? = xbl
 if flag = 1 then
  x$ = "  "
  XMRead handle1???, addr1??? + length???, x$, 2, xmsErr???
  y$ = left$(x$, 1)
  XMRead handle2???, addr2??? + length???, x$, 2, xmsErr???
  x$ = y$ + right$(x$, 1)
  XMWrite handle2???, addr2??? + length???, x$, 2, xmsErr???
 end if
END SUB





DEFINT A-Z
SUB MMDuplicateHandle (handle1???, handle2???, xmsErr???)
 'if handle2??? is null, it will be assigned
 TMGetStringLength handle1???, length???, xmsErr???

 if handle2??? = 0 then
  XMBlockSize handle1???, xmsRequest???, xmsErr???
  XMAllocate xmsRequest???, handle2???, xmsErr???
 end if

 XMCopy handle1???, 0, length???, handle2???, 0, xmsErr???
END SUB
